<?php

if( ! function_exists('bridge_qode_include_font_awesome_5_icon_pack') ){
    function bridge_qode_include_font_awesome_5_icon_pack( $icon_packs ){
        $icon_packs['font_awesome_5'] = esc_html__('Font Awesome 5+', 'bridge');

        return $icon_packs;
    }

    add_filter('bridge_qode_filter_icon_packs', 'bridge_qode_include_font_awesome_5_icon_pack');
}

class BridgeQodeIconsFontAwesome5 implements iIconCollection {

    public $icons;
    public $title;
    public $param;
    public $styleUrl;
	public $socialIcons;
	public $backTopTopIcons;

    function __construct($title = "", $param = "") {
        $this->icons = array();
        $this->socialIcons = array();
        $this->backTopTopIcons = array();
        $this->title = $title;
        $this->param = $param;
        $this->setIconsArray();
        $this->setBackToTopIconsArray();
        $this->styleUrl = QODE_ROOT . "/css/font-awesome-5/css/font-awesome-5.min.css";
    }

    private function setIconsArray() {
        $this->icons = array_flip(
            array(
	            "0" => "fa fa-0",
	            "1" => "fa fa-1",
	            "2" => "fa fa-2",
	            "3" => "fa fa-3",
	            "4" => "fa fa-4",
	            "5" => "fa fa-5",
	            "6" => "fa fa-6",
	            "7" => "fa fa-7",
	            "8" => "fa fa-8",
	            "9" => "fa fa-9",
	            "42.group" => "fab fa-42-group",
	            "500px" => "fab fa-500px",
	            "A" => "fa fa-a",
	            "Accessible Icon" => "fab fa-accessible-icon",
	            "Accusoft" => "fab fa-accusoft",
	            "Address Book" => "fa fa-address-book",
	            "Address Card" => "fa fa-address-card",
	            "App.net" => "fab fa-adn",
	            "Adversal" => "fab fa-adversal",
	            "Affiliatetheme" => "fab fa-affiliatetheme",
	            "Airbnb" => "fab fa-airbnb",
	            "Algolia" => "fab fa-algolia",
	            "Align Center" => "fa fa-align-center",
	            "Align Justify" => "fa fa-align-justify",
	            "Align Left" => "fa fa-align-left",
	            "Align Right" => "fa fa-align-right",
	            "Alipay" => "fab fa-alipay",
	            "Amazon" => "fab fa-amazon",
	            "Amazon Pay" => "fab fa-amazon-pay",
	            "Amilia" => "fab fa-amilia",
	            "Anchor" => "fa fa-anchor",
	            "Anchor Circle Check" => "fa fa-anchor-circle-check",
	            "Anchor Circle Exclamation" => "fa fa-anchor-circle-exclamation",
	            "Anchor Circle Xmark" => "fa fa-anchor-circle-xmark",
	            "Anchor Lock" => "fa fa-anchor-lock",
	            "Android" => "fab fa-android",
	            "AngelList" => "fab fa-angellist",
	            "Angle Down" => "fa fa-angle-down",
	            "Angle Left" => "fa fa-angle-left",
	            "Angle Right" => "fa fa-angle-right",
	            "Angle Up" => "fa fa-angle-up",
	            "Angles Down" => "fa fa-angles-down",
	            "Angles Left" => "fa fa-angles-left",
	            "Angles Right" => "fa fa-angles-right",
	            "Angles Up" => "fa fa-angles-up",
	            "Angry Creative" => "fab fa-angrycreative",
	            "Angular" => "fab fa-angular",
	            "Ankh" => "fa fa-ankh",
	            "App Store" => "fab fa-app-store",
	            "IOS App Store" => "fab fa-app-store-ios",
	            "Apper Systems AB" => "fab fa-apper",
	            "Apple" => "fab fa-apple",
	            "Apple Pay" => "fab fa-apple-pay",
	            "Apple Whole" => "fa fa-apple-whole",
	            "Archway" => "fa fa-archway",
	            "Arrow Down" => "fa fa-arrow-down",
	            "Arrow Down 1 9" => "fa fa-arrow-down-1-9",
	            "Arrow Down 9 1" => "fa fa-arrow-down-9-1",
	            "Arrow Down A Z" => "fa fa-arrow-down-a-z",
	            "Arrow Down Long" => "fa fa-arrow-down-long",
	            "Arrow Down Short Wide" => "fa fa-arrow-down-short-wide",
	            "Arrow Down Up Across Line" => "fa fa-arrow-down-up-across-line",
	            "Arrow Down Up Lock" => "fa fa-arrow-down-up-lock",
	            "Arrow Down Wide Short" => "fa fa-arrow-down-wide-short",
	            "Arrow Down Z A" => "fa fa-arrow-down-z-a",
	            "Arrow Left" => "fa fa-arrow-left",
	            "Arrow Left Long" => "fa fa-arrow-left-long",
	            "Arrow Pointer" => "fa fa-arrow-pointer",
	            "Arrow Right" => "fa fa-arrow-right",
	            "Arrow Right Arrow Left" => "fa fa-arrow-right-arrow-left",
	            "Arrow Right From Bracket" => "fa fa-arrow-right-from-bracket",
	            "Arrow Right Long" => "fa fa-arrow-right-long",
	            "Arrow Right To Bracket" => "fa fa-arrow-right-to-bracket",
	            "Arrow Right To City" => "fa fa-arrow-right-to-city",
	            "Arrow Rotate Left" => "fa fa-arrow-rotate-left",
	            "Arrow Rotate Right" => "fa fa-arrow-rotate-right",
	            "Arrow Trend Down" => "fa fa-arrow-trend-down",
	            "Arrow Trend Up" => "fa fa-arrow-trend-up",
	            "Arrow Turn Down" => "fa fa-arrow-turn-down",
	            "Arrow Turn Up" => "fa fa-arrow-turn-up",
	            "Arrow Up" => "fa fa-arrow-up",
	            "Arrow Up 1 9" => "fa fa-arrow-up-1-9",
	            "Arrow Up 9 1" => "fa fa-arrow-up-9-1",
	            "Arrow Up A Z" => "fa fa-arrow-up-a-z",
	            "Arrow Up From Bracket" => "fa fa-arrow-up-from-bracket",
	            "Arrow Up From Ground Water" => "fa fa-arrow-up-from-ground-water",
	            "Arrow Up From Water Pump" => "fa fa-arrow-up-from-water-pump",
	            "Arrow Up Long" => "fa fa-arrow-up-long",
	            "Arrow Up Right Dots" => "fa fa-arrow-up-right-dots",
	            "Arrow Up Right From Square" => "fa fa-arrow-up-right-from-square",
	            "Arrow Up Short Wide" => "fa fa-arrow-up-short-wide",
	            "Arrow Up Wide Short" => "fa fa-arrow-up-wide-short",
	            "Arrow Up Z A" => "fa fa-arrow-up-z-a",
	            "Arrows Down To Line" => "fa fa-arrows-down-to-line",
	            "Arrows Down To People" => "fa fa-arrows-down-to-people",
	            "Arrows Left Right" => "fa fa-arrows-left-right",
	            "Arrows Left Right To Line" => "fa fa-arrows-left-right-to-line",
	            "Arrows Rotate" => "fa fa-arrows-rotate",
	            "Arrows Spin" => "fa fa-arrows-spin",
	            "Arrows Split Up And Left" => "fa fa-arrows-split-up-and-left",
	            "Arrows To Circle" => "fa fa-arrows-to-circle",
	            "Arrows To Dot" => "fa fa-arrows-to-dot",
	            "Arrows To Eye" => "fa fa-arrows-to-eye",
	            "Arrows Turn Right" => "fa fa-arrows-turn-right",
	            "Arrows Turn To Dots" => "fa fa-arrows-turn-to-dots",
	            "Arrows Up Down" => "fa fa-arrows-up-down",
	            "Arrows Up Down Left Right" => "fa fa-arrows-up-down-left-right",
	            "Arrows Up To Line" => "fa fa-arrows-up-to-line",
	            "Artstation" => "fab fa-artstation",
	            "Asterisk" => "fa fa-asterisk",
	            "Asymmetrik, Ltd." => "fab fa-asymmetrik",
	            "At" => "fa fa-at",
	            "Atlassian" => "fab fa-atlassian",
	            "Atom" => "fa fa-atom",
	            "Audible" => "fab fa-audible",
	            "Audio Description" => "fa fa-audio-description",
	            "Austral Sign" => "fa fa-austral-sign",
	            "Autoprefixer" => "fab fa-autoprefixer",
	            "Avianex" => "fab fa-avianex",
	            "Aviato" => "fab fa-aviato",
	            "Award" => "fa fa-award",
	            "Amazon Web Services (AWS)" => "fab fa-aws",
	            "B" => "fa fa-b",
	            "Baby" => "fa fa-baby",
	            "Baby Carriage" => "fa fa-baby-carriage",
	            "Backward" => "fa fa-backward",
	            "Backward Fast" => "fa fa-backward-fast",
	            "Backward Step" => "fa fa-backward-step",
	            "Bacon" => "fa fa-bacon",
	            "Bacteria" => "fa fa-bacteria",
	            "Bacterium" => "fa fa-bacterium",
	            "Bag Shopping" => "fa fa-bag-shopping",
	            "Bahai" => "fa fa-bahai",
	            "Baht Sign" => "fa fa-baht-sign",
	            "Ban" => "fa fa-ban",
	            "Ban Smoking" => "fa fa-ban-smoking",
	            "Bandage" => "fa fa-bandage",
	            "Bandcamp" => "fab fa-bandcamp",
	            "Bangladeshi Taka Sign" => "fa fa-bangladeshi-taka-sign",
	            "Barcode" => "fa fa-barcode",
	            "Bars" => "fa fa-bars",
	            "Bars Progress" => "fa fa-bars-progress",
	            "Bars Staggered" => "fa fa-bars-staggered",
	            "Baseball" => "fa fa-baseball",
	            "Baseball Bat Ball" => "fa fa-baseball-bat-ball",
	            "Basket Shopping" => "fa fa-basket-shopping",
	            "Basketball" => "fa fa-basketball",
	            "Bath" => "fa fa-bath",
	            "Battery Empty" => "fa fa-battery-empty",
	            "Battery Full" => "fa fa-battery-full",
	            "Battery Half" => "fa fa-battery-half",
	            "Battery Quarter" => "fa fa-battery-quarter",
	            "Battery Three Quarters" => "fa fa-battery-three-quarters",
	            "Battle.net" => "fab fa-battle-net",
	            "Bed" => "fa fa-bed",
	            "Bed Pulse" => "fa fa-bed-pulse",
	            "Beer Mug Empty" => "fa fa-beer-mug-empty",
	            "Behance" => "fab fa-behance",
	            "Bell" => "fa fa-bell",
	            "Bell Concierge" => "fa fa-bell-concierge",
	            "Bell Slash" => "fa fa-bell-slash",
	            "Bezier Curve" => "fa fa-bezier-curve",
	            "Bicycle" => "fa fa-bicycle",
	            "Bilibili" => "fab fa-bilibili",
	            "BIMobject" => "fab fa-bimobject",
	            "Binoculars" => "fa fa-binoculars",
	            "Biohazard" => "fa fa-biohazard",
	            "Bitbucket" => "fab fa-bitbucket",
	            "Bitcoin" => "fab fa-bitcoin",
	            "Bitcoin Sign" => "fa fa-bitcoin-sign",
	            "Bity" => "fab fa-bity",
	            "Font Awesome Black Tie" => "fab fa-black-tie",
	            "BlackBerry" => "fab fa-blackberry",
	            "Blender" => "fa fa-blender",
	            "Blender Phone" => "fa fa-blender-phone",
	            "Blog" => "fa fa-blog",
	            "Blogger" => "fab fa-blogger",
	            "Blogger B" => "fab fa-blogger-b",
	            "Bluetooth" => "fab fa-bluetooth",
	            "Bluetooth" => "fab fa-bluetooth-b",
	            "Bold" => "fa fa-bold",
	            "Bolt" => "fa fa-bolt",
	            "Bolt Lightning" => "fa fa-bolt-lightning",
	            "Bomb" => "fa fa-bomb",
	            "Bone" => "fa fa-bone",
	            "Bong" => "fa fa-bong",
	            "Book" => "fa fa-book",
	            "Book Atlas" => "fa fa-book-atlas",
	            "Book Bible" => "fa fa-book-bible",
	            "Book Bookmark" => "fa fa-book-bookmark",
	            "Book Journal Whills" => "fa fa-book-journal-whills",
	            "Book Medical" => "fa fa-book-medical",
	            "Book Open" => "fa fa-book-open",
	            "Book Open Reader" => "fa fa-book-open-reader",
	            "Book Quran" => "fa fa-book-quran",
	            "Book Skull" => "fa fa-book-skull",
	            "Book Tanakh" => "fa fa-book-tanakh",
	            "Bookmark" => "fa fa-bookmark",
	            "Bootstrap" => "fab fa-bootstrap",
	            "Border All" => "fa fa-border-all",
	            "Border None" => "fa fa-border-none",
	            "Border Top Left" => "fa fa-border-top-left",
	            "Bore Hole" => "fa fa-bore-hole",
	            "Bots" => "fab fa-bots",
	            "Bottle Droplet" => "fa fa-bottle-droplet",
	            "Bottle Water" => "fa fa-bottle-water",
	            "Bowl Food" => "fa fa-bowl-food",
	            "Bowl Rice" => "fa fa-bowl-rice",
	            "Bowling Ball" => "fa fa-bowling-ball",
	            "Box" => "fa fa-box",
	            "Box Archive" => "fa fa-box-archive",
	            "Box Open" => "fa fa-box-open",
	            "Box Tissue" => "fa fa-box-tissue",
	            "Boxes Packing" => "fa fa-boxes-packing",
	            "Boxes Stacked" => "fa fa-boxes-stacked",
	            "Braille" => "fa fa-braille",
	            "Brain" => "fa fa-brain",
	            "Brazilian Real Sign" => "fa fa-brazilian-real-sign",
	            "Bread Slice" => "fa fa-bread-slice",
	            "Bridge" => "fa fa-bridge",
	            "Bridge Circle Check" => "fa fa-bridge-circle-check",
	            "Bridge Circle Exclamation" => "fa fa-bridge-circle-exclamation",
	            "Bridge Circle Xmark" => "fa fa-bridge-circle-xmark",
	            "Bridge Lock" => "fa fa-bridge-lock",
	            "Bridge Water" => "fa fa-bridge-water",
	            "Briefcase" => "fa fa-briefcase",
	            "Briefcase Medical" => "fa fa-briefcase-medical",
	            "Broom" => "fa fa-broom",
	            "Broom Ball" => "fa fa-broom-ball",
	            "Brush" => "fa fa-brush",
	            "BTC" => "fab fa-btc",
	            "Bucket" => "fa fa-bucket",
	            "Buffer" => "fab fa-buffer",
	            "Bug" => "fa fa-bug",
	            "Bug Slash" => "fa fa-bug-slash",
	            "Bugs" => "fa fa-bugs",
	            "Building" => "fa fa-building",
	            "Building Circle Arrow Right" => "fa fa-building-circle-arrow-right",
	            "Building Circle Check" => "fa fa-building-circle-check",
	            "Building Circle Exclamation" => "fa fa-building-circle-exclamation",
	            "Building Circle Xmark" => "fa fa-building-circle-xmark",
	            "Building Columns" => "fa fa-building-columns",
	            "Building Flag" => "fa fa-building-flag",
	            "Building Lock" => "fa fa-building-lock",
	            "Building Ngo" => "fa fa-building-ngo",
	            "Building Shield" => "fa fa-building-shield",
	            "Building Un" => "fa fa-building-un",
	            "Building User" => "fa fa-building-user",
	            "Building Wheat" => "fa fa-building-wheat",
	            "Bullhorn" => "fa fa-bullhorn",
	            "Bullseye" => "fa fa-bullseye",
	            "Burger" => "fa fa-burger",
	            "Büromöbel-Experte GmbH &amp; Co. KG." => "fab fa-buromobelexperte",
	            "Burst" => "fa fa-burst",
	            "Bus" => "fa fa-bus",
	            "Bus Simple" => "fa fa-bus-simple",
	            "Business Time" => "fa fa-business-time",
	            "Buy N Large" => "fab fa-buy-n-large",
	            "BuySellAds" => "fab fa-buysellads",
	            "C" => "fa fa-c",
	            "Cable Car" => "fa fa-cable-car",
	            "Cake Candles" => "fa fa-cake-candles",
	            "Calculator" => "fa fa-calculator",
	            "Calendar" => "fa fa-calendar",
	            "Calendar Check" => "fa fa-calendar-check",
	            "Calendar Day" => "fa fa-calendar-day",
	            "Calendar Days" => "fa fa-calendar-days",
	            "Calendar Minus" => "fa fa-calendar-minus",
	            "Calendar Plus" => "fa fa-calendar-plus",
	            "Calendar Week" => "fa fa-calendar-week",
	            "Calendar Xmark" => "fa fa-calendar-xmark",
	            "Camera" => "fa fa-camera",
	            "Camera Retro" => "fa fa-camera-retro",
	            "Camera Rotate" => "fa fa-camera-rotate",
	            "Campground" => "fa fa-campground",
	            "Canadian Maple Leaf" => "fab fa-canadian-maple-leaf",
	            "Candy Cane" => "fa fa-candy-cane",
	            "Cannabis" => "fa fa-cannabis",
	            "Capsules" => "fa fa-capsules",
	            "Car" => "fa fa-car",
	            "Car Battery" => "fa fa-car-battery",
	            "Car Burst" => "fa fa-car-burst",
	            "Car On" => "fa fa-car-on",
	            "Car Rear" => "fa fa-car-rear",
	            "Car Side" => "fa fa-car-side",
	            "Car Tunnel" => "fa fa-car-tunnel",
	            "Caravan" => "fa fa-caravan",
	            "Caret Down" => "fa fa-caret-down",
	            "Caret Left" => "fa fa-caret-left",
	            "Caret Right" => "fa fa-caret-right",
	            "Caret Up" => "fa fa-caret-up",
	            "Carrot" => "fa fa-carrot",
	            "Cart Arrow Down" => "fa fa-cart-arrow-down",
	            "Cart Flatbed" => "fa fa-cart-flatbed",
	            "Cart Flatbed Suitcase" => "fa fa-cart-flatbed-suitcase",
	            "Cart Plus" => "fa fa-cart-plus",
	            "Cart Shopping" => "fa fa-cart-shopping",
	            "Cash Register" => "fa fa-cash-register",
	            "Cat" => "fa fa-cat",
	            "Amazon Pay Credit Card" => "fab fa-cc-amazon-pay",
	            "American Express Credit Card" => "fab fa-cc-amex",
	            "Apple Pay Credit Card" => "fab fa-cc-apple-pay",
	            "Diner&#039;s Club Credit Card" => "fab fa-cc-diners-club",
	            "Discover Credit Card" => "fab fa-cc-discover",
	            "JCB Credit Card" => "fab fa-cc-jcb",
	            "MasterCard Credit Card" => "fab fa-cc-mastercard",
	            "Paypal Credit Card" => "fab fa-cc-paypal",
	            "Stripe Credit Card" => "fab fa-cc-stripe",
	            "Visa Credit Card" => "fab fa-cc-visa",
	            "Cedi Sign" => "fa fa-cedi-sign",
	            "Cent Sign" => "fa fa-cent-sign",
	            "Centercode" => "fab fa-centercode",
	            "Centos" => "fab fa-centos",
	            "Certificate" => "fa fa-certificate",
	            "Chair" => "fa fa-chair",
	            "Chalkboard" => "fa fa-chalkboard",
	            "Chalkboard User" => "fa fa-chalkboard-user",
	            "Champagne Glasses" => "fa fa-champagne-glasses",
	            "Charging Station" => "fa fa-charging-station",
	            "Chart Area" => "fa fa-chart-area",
	            "Chart Bar" => "fa fa-chart-bar",
	            "Chart Column" => "fa fa-chart-column",
	            "Chart Gantt" => "fa fa-chart-gantt",
	            "Chart Line" => "fa fa-chart-line",
	            "Chart Pie" => "fa fa-chart-pie",
	            "Chart Simple" => "fa fa-chart-simple",
	            "Check" => "fa fa-check",
	            "Check Double" => "fa fa-check-double",
	            "Check To Slot" => "fa fa-check-to-slot",
	            "Cheese" => "fa fa-cheese",
	            "Chess" => "fa fa-chess",
	            "Chess Bishop" => "fa fa-chess-bishop",
	            "Chess Board" => "fa fa-chess-board",
	            "Chess King" => "fa fa-chess-king",
	            "Chess Knight" => "fa fa-chess-knight",
	            "Chess Pawn" => "fa fa-chess-pawn",
	            "Chess Queen" => "fa fa-chess-queen",
	            "Chess Rook" => "fa fa-chess-rook",
	            "Chevron Down" => "fa fa-chevron-down",
	            "Chevron Left" => "fa fa-chevron-left",
	            "Chevron Right" => "fa fa-chevron-right",
	            "Chevron Up" => "fa fa-chevron-up",
	            "Child" => "fa fa-child",
	            "Child Combatant" => "fa fa-child-combatant",
	            "Child Dress" => "fa fa-child-dress",
	            "Child Reaching" => "fa fa-child-reaching",
	            "Children" => "fa fa-children",
	            "Chrome" => "fab fa-chrome",
	            "Chromecast" => "fab fa-chromecast",
	            "Church" => "fa fa-church",
	            "Circle" => "fa fa-circle",
	            "Circle Arrow Down" => "fa fa-circle-arrow-down",
	            "Circle Arrow Left" => "fa fa-circle-arrow-left",
	            "Circle Arrow Right" => "fa fa-circle-arrow-right",
	            "Circle Arrow Up" => "fa fa-circle-arrow-up",
	            "Circle Check" => "fa fa-circle-check",
	            "Circle Chevron Down" => "fa fa-circle-chevron-down",
	            "Circle Chevron Left" => "fa fa-circle-chevron-left",
	            "Circle Chevron Right" => "fa fa-circle-chevron-right",
	            "Circle Chevron Up" => "fa fa-circle-chevron-up",
	            "Circle Dollar To Slot" => "fa fa-circle-dollar-to-slot",
	            "Circle Dot" => "fa fa-circle-dot",
	            "Circle Down" => "fa fa-circle-down",
	            "Circle Exclamation" => "fa fa-circle-exclamation",
	            "Circle H" => "fa fa-circle-h",
	            "Circle Half Stroke" => "fa fa-circle-half-stroke",
	            "Circle Info" => "fa fa-circle-info",
	            "Circle Left" => "fa fa-circle-left",
	            "Circle Minus" => "fa fa-circle-minus",
	            "Circle Nodes" => "fa fa-circle-nodes",
	            "Circle Notch" => "fa fa-circle-notch",
	            "Circle Pause" => "fa fa-circle-pause",
	            "Circle Play" => "fa fa-circle-play",
	            "Circle Plus" => "fa fa-circle-plus",
	            "Circle Question" => "fa fa-circle-question",
	            "Circle Radiation" => "fa fa-circle-radiation",
	            "Circle Right" => "fa fa-circle-right",
	            "Circle Stop" => "fa fa-circle-stop",
	            "Circle Up" => "fa fa-circle-up",
	            "Circle User" => "fa fa-circle-user",
	            "Circle Xmark" => "fa fa-circle-xmark",
	            "City" => "fa fa-city",
	            "Clapperboard" => "fa fa-clapperboard",
	            "Clipboard" => "fa fa-clipboard",
	            "Clipboard Check" => "fa fa-clipboard-check",
	            "Clipboard List" => "fa fa-clipboard-list",
	            "Clipboard Question" => "fa fa-clipboard-question",
	            "Clipboard User" => "fa fa-clipboard-user",
	            "Clock" => "fa fa-clock",
	            "Clock Rotate Left" => "fa fa-clock-rotate-left",
	            "Clone" => "fa fa-clone",
	            "Closed Captioning" => "fa fa-closed-captioning",
	            "Cloud" => "fa fa-cloud",
	            "Cloud Arrow Down" => "fa fa-cloud-arrow-down",
	            "Cloud Arrow Up" => "fa fa-cloud-arrow-up",
	            "Cloud Bolt" => "fa fa-cloud-bolt",
	            "Cloud Meatball" => "fa fa-cloud-meatball",
	            "Cloud Moon" => "fa fa-cloud-moon",
	            "Cloud Moon Rain" => "fa fa-cloud-moon-rain",
	            "Cloud Rain" => "fa fa-cloud-rain",
	            "Cloud Showers Heavy" => "fa fa-cloud-showers-heavy",
	            "Cloud Showers Water" => "fa fa-cloud-showers-water",
	            "Cloud Sun" => "fa fa-cloud-sun",
	            "Cloud Sun Rain" => "fa fa-cloud-sun-rain",
	            "Cloudflare" => "fab fa-cloudflare",
	            "Cloudscale.ch" => "fab fa-cloudscale",
	            "Cloudsmith" => "fab fa-cloudsmith",
	            "Cloudversify" => "fab fa-cloudversify",
	            "Clover" => "fa fa-clover",
	            "Cmplid" => "fab fa-cmplid",
	            "Code" => "fa fa-code",
	            "Code Branch" => "fa fa-code-branch",
	            "Code Commit" => "fa fa-code-commit",
	            "Code Compare" => "fa fa-code-compare",
	            "Code Fork" => "fa fa-code-fork",
	            "Code Merge" => "fa fa-code-merge",
	            "Code Pull Request" => "fa fa-code-pull-request",
	            "Codepen" => "fab fa-codepen",
	            "Codie Pie" => "fab fa-codiepie",
	            "Coins" => "fa fa-coins",
	            "Colon Sign" => "fa fa-colon-sign",
	            "Comment" => "fa fa-comment",
	            "Comment Dollar" => "fa fa-comment-dollar",
	            "Comment Dots" => "fa fa-comment-dots",
	            "Comment Medical" => "fa fa-comment-medical",
	            "Comment Slash" => "fa fa-comment-slash",
	            "Comment Sms" => "fa fa-comment-sms",
	            "Comments" => "fa fa-comments",
	            "Comments Dollar" => "fa fa-comments-dollar",
	            "Compact Disc" => "fa fa-compact-disc",
	            "Compass" => "fa fa-compass",
	            "Compass Drafting" => "fa fa-compass-drafting",
	            "Compress" => "fa fa-compress",
	            "Computer" => "fa fa-computer",
	            "Computer Mouse" => "fa fa-computer-mouse",
	            "Confluence" => "fab fa-confluence",
	            "Connect Develop" => "fab fa-connectdevelop",
	            "Contao" => "fab fa-contao",
	            "Cookie" => "fa fa-cookie",
	            "Cookie Bite" => "fa fa-cookie-bite",
	            "Copy" => "fa fa-copy",
	            "Copyright" => "fa fa-copyright",
	            "Cotton Bureau" => "fab fa-cotton-bureau",
	            "Couch" => "fa fa-couch",
	            "Cow" => "fa fa-cow",
	            "CPanel" => "fab fa-cpanel",
	            "Creative Commons" => "fab fa-creative-commons",
	            "Creative Commons Attribution" => "fab fa-creative-commons-by",
	            "Creative Commons Noncommercial" => "fab fa-creative-commons-nc",
	            "Creative Commons Noncommercial (Euro Sign)" => "fab fa-creative-commons-nc-eu",
	            "Creative Commons Noncommercial (Yen Sign)" => "fab fa-creative-commons-nc-jp",
	            "Creative Commons No Derivative Works" => "fab fa-creative-commons-nd",
	            "Creative Commons Public Domain" => "fab fa-creative-commons-pd",
	            "Alternate Creative Commons Public Domain" => "fab fa-creative-commons-pd-alt",
	            "Creative Commons Remix" => "fab fa-creative-commons-remix",
	            "Creative Commons Share Alike" => "fab fa-creative-commons-sa",
	            "Creative Commons Sampling" => "fab fa-creative-commons-sampling",
	            "Creative Commons Sampling +" => "fab fa-creative-commons-sampling-plus",
	            "Creative Commons Share" => "fab fa-creative-commons-share",
	            "Creative Commons CC0" => "fab fa-creative-commons-zero",
	            "Credit Card" => "fa fa-credit-card",
	            "Critical Role" => "fab fa-critical-role",
	            "Crop" => "fa fa-crop",
	            "Crop Simple" => "fa fa-crop-simple",
	            "Cross" => "fa fa-cross",
	            "Crosshairs" => "fa fa-crosshairs",
	            "Crow" => "fa fa-crow",
	            "Crown" => "fa fa-crown",
	            "Crutch" => "fa fa-crutch",
	            "Cruzeiro Sign" => "fa fa-cruzeiro-sign",
	            "CSS 3 Logo" => "fab fa-css3",
	            "Alternate CSS3 Logo" => "fab fa-css3-alt",
	            "Cube" => "fa fa-cube",
	            "Cubes" => "fa fa-cubes",
	            "Cubes Stacked" => "fa fa-cubes-stacked",
	            "Cuttlefish" => "fab fa-cuttlefish",
	            "D" => "fa fa-d",
	            "Dungeons &amp; Dragons" => "fab fa-d-and-d",
	            "D&amp;D Beyond" => "fab fa-d-and-d-beyond",
	            "Dailymotion" => "fab fa-dailymotion",
	            "DashCube" => "fab fa-dashcube",
	            "Database" => "fa fa-database",
	            "Debian" => "fab fa-debian",
	            "Deezer" => "fab fa-deezer",
	            "Delete Left" => "fa fa-delete-left",
	            "Delicious" => "fab fa-delicious",
	            "Democrat" => "fa fa-democrat",
	            "Deploy.dog" => "fab fa-deploydog",
	            "Deskpro" => "fab fa-deskpro",
	            "Desktop" => "fa fa-desktop",
	            "DEV" => "fab fa-dev",
	            "DeviantART" => "fab fa-deviantart",
	            "Dharmachakra" => "fa fa-dharmachakra",
	            "DHL" => "fab fa-dhl",
	            "Diagram Next" => "fa fa-diagram-next",
	            "Diagram Predecessor" => "fa fa-diagram-predecessor",
	            "Diagram Project" => "fa fa-diagram-project",
	            "Diagram Successor" => "fa fa-diagram-successor",
	            "Diamond" => "fa fa-diamond",
	            "Diamond Turn Right" => "fa fa-diamond-turn-right",
	            "Diaspora" => "fab fa-diaspora",
	            "Dice" => "fa fa-dice",
	            "Dice D20" => "fa fa-dice-d20",
	            "Dice D6" => "fa fa-dice-d6",
	            "Dice Five" => "fa fa-dice-five",
	            "Dice Four" => "fa fa-dice-four",
	            "Dice One" => "fa fa-dice-one",
	            "Dice Six" => "fa fa-dice-six",
	            "Dice Three" => "fa fa-dice-three",
	            "Dice Two" => "fa fa-dice-two",
	            "Digg Logo" => "fab fa-digg",
	            "Digital Ocean" => "fab fa-digital-ocean",
	            "Discord" => "fab fa-discord",
	            "Discourse" => "fab fa-discourse",
	            "Disease" => "fa fa-disease",
	            "Display" => "fa fa-display",
	            "Divide" => "fa fa-divide",
	            "Dna" => "fa fa-dna",
	            "DocHub" => "fab fa-dochub",
	            "Docker" => "fab fa-docker",
	            "Dog" => "fa fa-dog",
	            "Dollar Sign" => "fa fa-dollar-sign",
	            "Dolly" => "fa fa-dolly",
	            "Dong Sign" => "fa fa-dong-sign",
	            "Door Closed" => "fa fa-door-closed",
	            "Door Open" => "fa fa-door-open",
	            "Dove" => "fa fa-dove",
	            "Down Left And Up Right To Center" => "fa fa-down-left-and-up-right-to-center",
	            "Down Long" => "fa fa-down-long",
	            "Download" => "fa fa-download",
	            "Draft2digital" => "fab fa-draft2digital",
	            "Dragon" => "fa fa-dragon",
	            "Draw Polygon" => "fa fa-draw-polygon",
	            "Dribbble" => "fab fa-dribbble",
	            "Dropbox" => "fab fa-dropbox",
	            "Droplet" => "fa fa-droplet",
	            "Droplet Slash" => "fa fa-droplet-slash",
	            "Drum" => "fa fa-drum",
	            "Drum Steelpan" => "fa fa-drum-steelpan",
	            "Drumstick Bite" => "fa fa-drumstick-bite",
	            "Drupal Logo" => "fab fa-drupal",
	            "Dumbbell" => "fa fa-dumbbell",
	            "Dumpster" => "fa fa-dumpster",
	            "Dumpster Fire" => "fa fa-dumpster-fire",
	            "Dungeon" => "fa fa-dungeon",
	            "Dyalog" => "fab fa-dyalog",
	            "E" => "fa fa-e",
	            "Ear Deaf" => "fa fa-ear-deaf",
	            "Ear Listen" => "fa fa-ear-listen",
	            "Earlybirds" => "fab fa-earlybirds",
	            "Earth Africa" => "fa fa-earth-africa",
	            "Earth Americas" => "fa fa-earth-americas",
	            "Earth Asia" => "fa fa-earth-asia",
	            "Earth Europe" => "fa fa-earth-europe",
	            "Earth Oceania" => "fa fa-earth-oceania",
	            "EBay" => "fab fa-ebay",
	            "Edge Browser" => "fab fa-edge",
	            "Edge Legacy Browser" => "fab fa-edge-legacy",
	            "Egg" => "fa fa-egg",
	            "Eject" => "fa fa-eject",
	            "Elementor" => "fab fa-elementor",
	            "Elevator" => "fa fa-elevator",
	            "Ellipsis" => "fa fa-ellipsis",
	            "Ellipsis Vertical" => "fa fa-ellipsis-vertical",
	            "Ello" => "fab fa-ello",
	            "Ember" => "fab fa-ember",
	            "Galactic Empire" => "fab fa-empire",
	            "Envelope" => "fa fa-envelope",
	            "Envelope Circle Check" => "fa fa-envelope-circle-check",
	            "Envelope Open" => "fa fa-envelope-open",
	            "Envelope Open Text" => "fa fa-envelope-open-text",
	            "Envelopes Bulk" => "fa fa-envelopes-bulk",
	            "Envira Gallery" => "fab fa-envira",
	            "Equals" => "fa fa-equals",
	            "Eraser" => "fa fa-eraser",
	            "Erlang" => "fab fa-erlang",
	            "Ethereum" => "fab fa-ethereum",
	            "Ethernet" => "fa fa-ethernet",
	            "Etsy" => "fab fa-etsy",
	            "Euro Sign" => "fa fa-euro-sign",
	            "Evernote" => "fab fa-evernote",
	            "Exclamation" => "fa fa-exclamation",
	            "Expand" => "fa fa-expand",
	            "ExpeditedSSL" => "fab fa-expeditedssl",
	            "Explosion" => "fa fa-explosion",
	            "Eye" => "fa fa-eye",
	            "Eye Dropper" => "fa fa-eye-dropper",
	            "Eye Low Vision" => "fa fa-eye-low-vision",
	            "Eye Slash" => "fa fa-eye-slash",
	            "F" => "fa fa-f",
	            "Face Angry" => "fa fa-face-angry",
	            "Face Dizzy" => "fa fa-face-dizzy",
	            "Face Flushed" => "fa fa-face-flushed",
	            "Face Frown" => "fa fa-face-frown",
	            "Face Frown Open" => "fa fa-face-frown-open",
	            "Face Grimace" => "fa fa-face-grimace",
	            "Face Grin" => "fa fa-face-grin",
	            "Face Grin Beam" => "fa fa-face-grin-beam",
	            "Face Grin Beam Sweat" => "fa fa-face-grin-beam-sweat",
	            "Face Grin Hearts" => "fa fa-face-grin-hearts",
	            "Face Grin Squint" => "fa fa-face-grin-squint",
	            "Face Grin Squint Tears" => "fa fa-face-grin-squint-tears",
	            "Face Grin Stars" => "fa fa-face-grin-stars",
	            "Face Grin Tears" => "fa fa-face-grin-tears",
	            "Face Grin Tongue" => "fa fa-face-grin-tongue",
	            "Face Grin Tongue Squint" => "fa fa-face-grin-tongue-squint",
	            "Face Grin Tongue Wink" => "fa fa-face-grin-tongue-wink",
	            "Face Grin Wide" => "fa fa-face-grin-wide",
	            "Face Grin Wink" => "fa fa-face-grin-wink",
	            "Face Kiss" => "fa fa-face-kiss",
	            "Face Kiss Beam" => "fa fa-face-kiss-beam",
	            "Face Kiss Wink Heart" => "fa fa-face-kiss-wink-heart",
	            "Face Laugh" => "fa fa-face-laugh",
	            "Face Laugh Beam" => "fa fa-face-laugh-beam",
	            "Face Laugh Squint" => "fa fa-face-laugh-squint",
	            "Face Laugh Wink" => "fa fa-face-laugh-wink",
	            "Face Meh" => "fa fa-face-meh",
	            "Face Meh Blank" => "fa fa-face-meh-blank",
	            "Face Rolling Eyes" => "fa fa-face-rolling-eyes",
	            "Face Sad Cry" => "fa fa-face-sad-cry",
	            "Face Sad Tear" => "fa fa-face-sad-tear",
	            "Face Smile" => "fa fa-face-smile",
	            "Face Smile Beam" => "fa fa-face-smile-beam",
	            "Face Smile Wink" => "fa fa-face-smile-wink",
	            "Face Surprise" => "fa fa-face-surprise",
	            "Face Tired" => "fa fa-face-tired",
	            "Facebook" => "fab fa-facebook",
	            "Facebook F" => "fab fa-facebook-f",
	            "Facebook Messenger" => "fab fa-facebook-messenger",
	            "Fan" => "fa fa-fan",
	            "Fantasy Flight-games" => "fab fa-fantasy-flight-games",
	            "Faucet" => "fa fa-faucet",
	            "Faucet Drip" => "fa fa-faucet-drip",
	            "Fax" => "fa fa-fax",
	            "Feather" => "fa fa-feather",
	            "Feather Pointed" => "fa fa-feather-pointed",
	            "FedEx" => "fab fa-fedex",
	            "Fedora" => "fab fa-fedora",
	            "Ferry" => "fa fa-ferry",
	            "Figma" => "fab fa-figma",
	            "File" => "fa fa-file",
	            "File Arrow Down" => "fa fa-file-arrow-down",
	            "File Arrow Up" => "fa fa-file-arrow-up",
	            "File Audio" => "fa fa-file-audio",
	            "File Circle Check" => "fa fa-file-circle-check",
	            "File Circle Exclamation" => "fa fa-file-circle-exclamation",
	            "File Circle Minus" => "fa fa-file-circle-minus",
	            "File Circle Plus" => "fa fa-file-circle-plus",
	            "File Circle Question" => "fa fa-file-circle-question",
	            "File Circle Xmark" => "fa fa-file-circle-xmark",
	            "File Code" => "fa fa-file-code",
	            "File Contract" => "fa fa-file-contract",
	            "File Csv" => "fa fa-file-csv",
	            "File Excel" => "fa fa-file-excel",
	            "File Export" => "fa fa-file-export",
	            "File Image" => "fa fa-file-image",
	            "File Import" => "fa fa-file-import",
	            "File Invoice" => "fa fa-file-invoice",
	            "File Invoice Dollar" => "fa fa-file-invoice-dollar",
	            "File Lines" => "fa fa-file-lines",
	            "File Medical" => "fa fa-file-medical",
	            "File Pdf" => "fa fa-file-pdf",
	            "File Pen" => "fa fa-file-pen",
	            "File Powerpoint" => "fa fa-file-powerpoint",
	            "File Prescription" => "fa fa-file-prescription",
	            "File Shield" => "fa fa-file-shield",
	            "File Signature" => "fa fa-file-signature",
	            "File Video" => "fa fa-file-video",
	            "File Waveform" => "fa fa-file-waveform",
	            "File Word" => "fa fa-file-word",
	            "File Zipper" => "fa fa-file-zipper",
	            "Fill" => "fa fa-fill",
	            "Fill Drip" => "fa fa-fill-drip",
	            "Film" => "fa fa-film",
	            "Filter" => "fa fa-filter",
	            "Filter Circle Dollar" => "fa fa-filter-circle-dollar",
	            "Filter Circle Xmark" => "fa fa-filter-circle-xmark",
	            "Fingerprint" => "fa fa-fingerprint",
	            "Fire" => "fa fa-fire",
	            "Fire Burner" => "fa fa-fire-burner",
	            "Fire Extinguisher" => "fa fa-fire-extinguisher",
	            "Fire Flame Curved" => "fa fa-fire-flame-curved",
	            "Fire Flame Simple" => "fa fa-fire-flame-simple",
	            "Firefox" => "fab fa-firefox",
	            "Firefox Browser" => "fab fa-firefox-browser",
	            "First Order" => "fab fa-first-order",
	            "Alternate First Order" => "fab fa-first-order-alt",
	            "Firstdraft" => "fab fa-firstdraft",
	            "Fish" => "fa fa-fish",
	            "Fish Fins" => "fa fa-fish-fins",
	            "Flag" => "fa fa-flag",
	            "Flag Checkered" => "fa fa-flag-checkered",
	            "Flag Usa" => "fa fa-flag-usa",
	            "Flask" => "fa fa-flask",
	            "Flask Vial" => "fa fa-flask-vial",
	            "Flickr" => "fab fa-flickr",
	            "Flipboard" => "fab fa-flipboard",
	            "Floppy Disk" => "fa fa-floppy-disk",
	            "Florin Sign" => "fa fa-florin-sign",
	            "Fly" => "fab fa-fly",
	            "Folder" => "fa fa-folder",
	            "Folder Closed" => "fa fa-folder-closed",
	            "Folder Minus" => "fa fa-folder-minus",
	            "Folder Open" => "fa fa-folder-open",
	            "Folder Plus" => "fa fa-folder-plus",
	            "Folder Tree" => "fa fa-folder-tree",
	            "Font" => "fa fa-font",
	            "Font Awesome" => "fab fa-font-awesome",
	            "Fonticons" => "fab fa-fonticons",
	            "Fonticons Fi" => "fab fa-fonticons-fi",
	            "Football" => "fa fa-football",
	            "Fort Awesome" => "fab fa-fort-awesome",
	            "Alternate Fort Awesome" => "fab fa-fort-awesome-alt",
	            "Forumbee" => "fab fa-forumbee",
	            "Forward" => "fa fa-forward",
	            "Forward Fast" => "fa fa-forward-fast",
	            "Forward Step" => "fa fa-forward-step",
	            "Foursquare" => "fab fa-foursquare",
	            "Franc Sign" => "fa fa-franc-sign",
	            "FreeCodeCamp" => "fab fa-free-code-camp",
	            "FreeBSD" => "fab fa-freebsd",
	            "Frog" => "fa fa-frog",
	            "Fulcrum" => "fab fa-fulcrum",
	            "Futbol" => "fa fa-futbol",
	            "G" => "fa fa-g",
	            "Galactic Republic" => "fab fa-galactic-republic",
	            "Galactic Senate" => "fab fa-galactic-senate",
	            "Gamepad" => "fa fa-gamepad",
	            "Gas Pump" => "fa fa-gas-pump",
	            "Gauge" => "fa fa-gauge",
	            "Gauge High" => "fa fa-gauge-high",
	            "Gauge Simple" => "fa fa-gauge-simple",
	            "Gauge Simple High" => "fa fa-gauge-simple-high",
	            "Gavel" => "fa fa-gavel",
	            "Gear" => "fa fa-gear",
	            "Gears" => "fa fa-gears",
	            "Gem" => "fa fa-gem",
	            "Genderless" => "fa fa-genderless",
	            "Get Pocket" => "fab fa-get-pocket",
	            "GG Currency" => "fab fa-gg",
	            "GG Currency Circle" => "fab fa-gg-circle",
	            "Ghost" => "fa fa-ghost",
	            "Gift" => "fa fa-gift",
	            "Gifts" => "fa fa-gifts",
	            "Git" => "fab fa-git",
	            "Git Alt" => "fab fa-git-alt",
	            "GitHub" => "fab fa-github",
	            "Alternate GitHub" => "fab fa-github-alt",
	            "GitKraken" => "fab fa-gitkraken",
	            "GitLab" => "fab fa-gitlab",
	            "Gitter" => "fab fa-gitter",
	            "Glass Water" => "fa fa-glass-water",
	            "Glass Water Droplet" => "fa fa-glass-water-droplet",
	            "Glasses" => "fa fa-glasses",
	            "Glide" => "fab fa-glide",
	            "Glide G" => "fab fa-glide-g",
	            "Globe" => "fa fa-globe",
	            "Gofore" => "fab fa-gofore",
	            "Go" => "fab fa-golang",
	            "Golf Ball Tee" => "fa fa-golf-ball-tee",
	            "Goodreads" => "fab fa-goodreads",
	            "Goodreads G" => "fab fa-goodreads-g",
	            "Google Logo" => "fab fa-google",
	            "Google Drive" => "fab fa-google-drive",
	            "Google Pay" => "fab fa-google-pay",
	            "Google Play" => "fab fa-google-play",
	            "Google Plus" => "fab fa-google-plus",
	            "Google Plus G" => "fab fa-google-plus-g",
	            "Google Wallet" => "fab fa-google-wallet",
	            "Gopuram" => "fa fa-gopuram",
	            "Graduation Cap" => "fa fa-graduation-cap",
	            "Gratipay (Gittip)" => "fab fa-gratipay",
	            "Grav" => "fab fa-grav",
	            "Greater Than" => "fa fa-greater-than",
	            "Greater Than Equal" => "fa fa-greater-than-equal",
	            "Grip" => "fa fa-grip",
	            "Grip Lines" => "fa fa-grip-lines",
	            "Grip Lines Vertical" => "fa fa-grip-lines-vertical",
	            "Grip Vertical" => "fa fa-grip-vertical",
	            "Gripfire, Inc." => "fab fa-gripfire",
	            "Group Arrows Rotate" => "fa fa-group-arrows-rotate",
	            "Grunt" => "fab fa-grunt",
	            "Guarani Sign" => "fa fa-guarani-sign",
	            "Guilded" => "fab fa-guilded",
	            "Guitar" => "fa fa-guitar",
	            "Gulp" => "fab fa-gulp",
	            "Gun" => "fa fa-gun",
	            "H" => "fa fa-h",
	            "Hacker News" => "fab fa-hacker-news",
	            "Hackerrank" => "fab fa-hackerrank",
	            "Hammer" => "fa fa-hammer",
	            "Hamsa" => "fa fa-hamsa",
	            "Hand" => "fa fa-hand",
	            "Hand Back Fist" => "fa fa-hand-back-fist",
	            "Hand Dots" => "fa fa-hand-dots",
	            "Hand Fist" => "fa fa-hand-fist",
	            "Hand Holding" => "fa fa-hand-holding",
	            "Hand Holding Dollar" => "fa fa-hand-holding-dollar",
	            "Hand Holding Droplet" => "fa fa-hand-holding-droplet",
	            "Hand Holding Hand" => "fa fa-hand-holding-hand",
	            "Hand Holding Heart" => "fa fa-hand-holding-heart",
	            "Hand Holding Medical" => "fa fa-hand-holding-medical",
	            "Hand Lizard" => "fa fa-hand-lizard",
	            "Hand Middle Finger" => "fa fa-hand-middle-finger",
	            "Hand Peace" => "fa fa-hand-peace",
	            "Hand Point Down" => "fa fa-hand-point-down",
	            "Hand Point Left" => "fa fa-hand-point-left",
	            "Hand Point Right" => "fa fa-hand-point-right",
	            "Hand Point Up" => "fa fa-hand-point-up",
	            "Hand Pointer" => "fa fa-hand-pointer",
	            "Hand Scissors" => "fa fa-hand-scissors",
	            "Hand Sparkles" => "fa fa-hand-sparkles",
	            "Hand Spock" => "fa fa-hand-spock",
	            "Handcuffs" => "fa fa-handcuffs",
	            "Hands" => "fa fa-hands",
	            "Hands Asl Interpreting" => "fa fa-hands-asl-interpreting",
	            "Hands Bound" => "fa fa-hands-bound",
	            "Hands Bubbles" => "fa fa-hands-bubbles",
	            "Hands Clapping" => "fa fa-hands-clapping",
	            "Hands Holding" => "fa fa-hands-holding",
	            "Hands Holding Child" => "fa fa-hands-holding-child",
	            "Hands Holding Circle" => "fa fa-hands-holding-circle",
	            "Hands Praying" => "fa fa-hands-praying",
	            "Handshake" => "fa fa-handshake",
	            "Handshake Angle" => "fa fa-handshake-angle",
	            "Handshake Simple" => "fa fa-handshake-simple",
	            "Handshake Simple Slash" => "fa fa-handshake-simple-slash",
	            "Handshake Slash" => "fa fa-handshake-slash",
	            "Hanukiah" => "fa fa-hanukiah",
	            "Hard Drive" => "fa fa-hard-drive",
	            "Hashnode" => "fab fa-hashnode",
	            "Hashtag" => "fa fa-hashtag",
	            "Hat Cowboy" => "fa fa-hat-cowboy",
	            "Hat Cowboy Side" => "fa fa-hat-cowboy-side",
	            "Hat Wizard" => "fa fa-hat-wizard",
	            "Head Side Cough" => "fa fa-head-side-cough",
	            "Head Side Cough Slash" => "fa fa-head-side-cough-slash",
	            "Head Side Mask" => "fa fa-head-side-mask",
	            "Head Side Virus" => "fa fa-head-side-virus",
	            "Heading" => "fa fa-heading",
	            "Headphones" => "fa fa-headphones",
	            "Headphones Simple" => "fa fa-headphones-simple",
	            "Headset" => "fa fa-headset",
	            "Heart" => "fa fa-heart",
	            "Heart Circle Bolt" => "fa fa-heart-circle-bolt",
	            "Heart Circle Check" => "fa fa-heart-circle-check",
	            "Heart Circle Exclamation" => "fa fa-heart-circle-exclamation",
	            "Heart Circle Minus" => "fa fa-heart-circle-minus",
	            "Heart Circle Plus" => "fa fa-heart-circle-plus",
	            "Heart Circle Xmark" => "fa fa-heart-circle-xmark",
	            "Heart Crack" => "fa fa-heart-crack",
	            "Heart Pulse" => "fa fa-heart-pulse",
	            "Helicopter" => "fa fa-helicopter",
	            "Helicopter Symbol" => "fa fa-helicopter-symbol",
	            "Helmet Safety" => "fa fa-helmet-safety",
	            "Helmet Un" => "fa fa-helmet-un",
	            "Highlighter" => "fa fa-highlighter",
	            "Hill Avalanche" => "fa fa-hill-avalanche",
	            "Hill Rockslide" => "fa fa-hill-rockslide",
	            "Hippo" => "fa fa-hippo",
	            "Hips" => "fab fa-hips",
	            "HireAHelper" => "fab fa-hire-a-helper",
	            "Hive Blockchain Network" => "fab fa-hive",
	            "Hockey Puck" => "fa fa-hockey-puck",
	            "Holly Berry" => "fa fa-holly-berry",
	            "Hooli" => "fab fa-hooli",
	            "Hornbill" => "fab fa-hornbill",
	            "Horse" => "fa fa-horse",
	            "Horse Head" => "fa fa-horse-head",
	            "Hospital" => "fa fa-hospital",
	            "Hospital User" => "fa fa-hospital-user",
	            "Hot Tub Person" => "fa fa-hot-tub-person",
	            "Hotdog" => "fa fa-hotdog",
	            "Hotel" => "fa fa-hotel",
	            "Hotjar" => "fab fa-hotjar",
	            "Hourglass" => "fa fa-hourglass",
	            "Hourglass End" => "fa fa-hourglass-end",
	            "Hourglass Half" => "fa fa-hourglass-half",
	            "Hourglass Start" => "fa fa-hourglass-start",
	            "House" => "fa fa-house",
	            "House Chimney" => "fa fa-house-chimney",
	            "House Chimney Crack" => "fa fa-house-chimney-crack",
	            "House Chimney Medical" => "fa fa-house-chimney-medical",
	            "House Chimney User" => "fa fa-house-chimney-user",
	            "House Chimney Window" => "fa fa-house-chimney-window",
	            "House Circle Check" => "fa fa-house-circle-check",
	            "House Circle Exclamation" => "fa fa-house-circle-exclamation",
	            "House Circle Xmark" => "fa fa-house-circle-xmark",
	            "House Crack" => "fa fa-house-crack",
	            "House Fire" => "fa fa-house-fire",
	            "House Flag" => "fa fa-house-flag",
	            "House Flood Water" => "fa fa-house-flood-water",
	            "House Flood Water Circle Arrow Right" => "fa fa-house-flood-water-circle-arrow-right",
	            "House Laptop" => "fa fa-house-laptop",
	            "House Lock" => "fa fa-house-lock",
	            "House Medical" => "fa fa-house-medical",
	            "House Medical Circle Check" => "fa fa-house-medical-circle-check",
	            "House Medical Circle Exclamation" => "fa fa-house-medical-circle-exclamation",
	            "House Medical Circle Xmark" => "fa fa-house-medical-circle-xmark",
	            "House Medical Flag" => "fa fa-house-medical-flag",
	            "House Signal" => "fa fa-house-signal",
	            "House Tsunami" => "fa fa-house-tsunami",
	            "House User" => "fa fa-house-user",
	            "Houzz" => "fab fa-houzz",
	            "Hryvnia Sign" => "fa fa-hryvnia-sign",
	            "HTML 5 Logo" => "fab fa-html5",
	            "HubSpot" => "fab fa-hubspot",
	            "Hurricane" => "fa fa-hurricane",
	            "I" => "fa fa-i",
	            "I Cursor" => "fa fa-i-cursor",
	            "Ice Cream" => "fa fa-ice-cream",
	            "Icicles" => "fa fa-icicles",
	            "Icons" => "fa fa-icons",
	            "Id Badge" => "fa fa-id-badge",
	            "Id Card" => "fa fa-id-card",
	            "Id Card Clip" => "fa fa-id-card-clip",
	            "IDeal" => "fab fa-ideal",
	            "Igloo" => "fa fa-igloo",
	            "Image" => "fa fa-image",
	            "Image Portrait" => "fa fa-image-portrait",
	            "Images" => "fa fa-images",
	            "IMDB" => "fab fa-imdb",
	            "Inbox" => "fa fa-inbox",
	            "Indent" => "fa fa-indent",
	            "Indian Rupee Sign" => "fa fa-indian-rupee-sign",
	            "Industry" => "fa fa-industry",
	            "Infinity" => "fa fa-infinity",
	            "Info" => "fa fa-info",
	            "Instagram" => "fab fa-instagram",
	            "InstaLOD" => "fab fa-instalod",
	            "Intercom" => "fab fa-intercom",
	            "Internet-explorer" => "fab fa-internet-explorer",
	            "InVision" => "fab fa-invision",
	            "Ioxhost" => "fab fa-ioxhost",
	            "Italic" => "fa fa-italic",
	            "Itch.io" => "fab fa-itch-io",
	            "ITunes" => "fab fa-itunes",
	            "Itunes Note" => "fab fa-itunes-note",
	            "J" => "fa fa-j",
	            "Jar" => "fa fa-jar",
	            "Jar Wheat" => "fa fa-jar-wheat",
	            "Java" => "fab fa-java",
	            "Jedi" => "fa fa-jedi",
	            "Jedi Order" => "fab fa-jedi-order",
	            "Jenkis" => "fab fa-jenkins",
	            "Jet Fighter" => "fa fa-jet-fighter",
	            "Jet Fighter Up" => "fa fa-jet-fighter-up",
	            "Jira" => "fab fa-jira",
	            "Joget" => "fab fa-joget",
	            "Joint" => "fa fa-joint",
	            "Joomla Logo" => "fab fa-joomla",
	            "JavaScript (JS)" => "fab fa-js",
	            "JsFiddle" => "fab fa-jsfiddle",
	            "Jug Detergent" => "fa fa-jug-detergent",
	            "K" => "fa fa-k",
	            "Kaaba" => "fa fa-kaaba",
	            "Kaggle" => "fab fa-kaggle",
	            "Key" => "fa fa-key",
	            "Keybase" => "fab fa-keybase",
	            "Keyboard" => "fa fa-keyboard",
	            "KeyCDN" => "fab fa-keycdn",
	            "Khanda" => "fa fa-khanda",
	            "Kickstarter" => "fab fa-kickstarter",
	            "Kickstarter K" => "fab fa-kickstarter-k",
	            "Kip Sign" => "fa fa-kip-sign",
	            "Kit Medical" => "fa fa-kit-medical",
	            "Kitchen Set" => "fa fa-kitchen-set",
	            "Kiwi Bird" => "fa fa-kiwi-bird",
	            "KORVUE" => "fab fa-korvue",
	            "L" => "fa fa-l",
	            "Land Mine On" => "fa fa-land-mine-on",
	            "Landmark" => "fa fa-landmark",
	            "Landmark Dome" => "fa fa-landmark-dome",
	            "Landmark Flag" => "fa fa-landmark-flag",
	            "Language" => "fa fa-language",
	            "Laptop" => "fa fa-laptop",
	            "Laptop Code" => "fa fa-laptop-code",
	            "Laptop File" => "fa fa-laptop-file",
	            "Laptop Medical" => "fa fa-laptop-medical",
	            "Laravel" => "fab fa-laravel",
	            "Lari Sign" => "fa fa-lari-sign",
	            "Last.fm" => "fab fa-lastfm",
	            "Layer Group" => "fa fa-layer-group",
	            "Leaf" => "fa fa-leaf",
	            "Leanpub" => "fab fa-leanpub",
	            "Left Long" => "fa fa-left-long",
	            "Left Right" => "fa fa-left-right",
	            "Lemon" => "fa fa-lemon",
	            "Less" => "fab fa-less",
	            "Less Than" => "fa fa-less-than",
	            "Less Than Equal" => "fa fa-less-than-equal",
	            "Life Ring" => "fa fa-life-ring",
	            "Lightbulb" => "fa fa-lightbulb",
	            "Line" => "fab fa-line",
	            "Lines Leaning" => "fa fa-lines-leaning",
	            "Link" => "fa fa-link",
	            "Link Slash" => "fa fa-link-slash",
	            "LinkedIn" => "fab fa-linkedin",
	            "LinkedIn In" => "fab fa-linkedin-in",
	            "Linode" => "fab fa-linode",
	            "Linux" => "fab fa-linux",
	            "Lira Sign" => "fa fa-lira-sign",
	            "List" => "fa fa-list",
	            "List Check" => "fa fa-list-check",
	            "List Ol" => "fa fa-list-ol",
	            "List Ul" => "fa fa-list-ul",
	            "Litecoin Sign" => "fa fa-litecoin-sign",
	            "Location Arrow" => "fa fa-location-arrow",
	            "Location Crosshairs" => "fa fa-location-crosshairs",
	            "Location Dot" => "fa fa-location-dot",
	            "Location Pin" => "fa fa-location-pin",
	            "Location Pin Lock" => "fa fa-location-pin-lock",
	            "Lock" => "fa fa-lock",
	            "Lock Open" => "fa fa-lock-open",
	            "Locust" => "fa fa-locust",
	            "Lungs" => "fa fa-lungs",
	            "Lungs Virus" => "fa fa-lungs-virus",
	            "Lyft" => "fab fa-lyft",
	            "M" => "fa fa-m",
	            "Magento" => "fab fa-magento",
	            "Magnet" => "fa fa-magnet",
	            "Magnifying Glass" => "fa fa-magnifying-glass",
	            "Magnifying Glass Arrow Right" => "fa fa-magnifying-glass-arrow-right",
	            "Magnifying Glass Chart" => "fa fa-magnifying-glass-chart",
	            "Magnifying Glass Dollar" => "fa fa-magnifying-glass-dollar",
	            "Magnifying Glass Location" => "fa fa-magnifying-glass-location",
	            "Magnifying Glass Minus" => "fa fa-magnifying-glass-minus",
	            "Magnifying Glass Plus" => "fa fa-magnifying-glass-plus",
	            "Mailchimp" => "fab fa-mailchimp",
	            "Manat Sign" => "fa fa-manat-sign",
	            "Mandalorian" => "fab fa-mandalorian",
	            "Map" => "fa fa-map",
	            "Map Location" => "fa fa-map-location",
	            "Map Location Dot" => "fa fa-map-location-dot",
	            "Map Pin" => "fa fa-map-pin",
	            "Markdown" => "fab fa-markdown",
	            "Marker" => "fa fa-marker",
	            "Mars" => "fa fa-mars",
	            "Mars And Venus" => "fa fa-mars-and-venus",
	            "Mars And Venus Burst" => "fa fa-mars-and-venus-burst",
	            "Mars Double" => "fa fa-mars-double",
	            "Mars Stroke" => "fa fa-mars-stroke",
	            "Mars Stroke Right" => "fa fa-mars-stroke-right",
	            "Mars Stroke Up" => "fa fa-mars-stroke-up",
	            "Martini Glass" => "fa fa-martini-glass",
	            "Martini Glass Citrus" => "fa fa-martini-glass-citrus",
	            "Martini Glass Empty" => "fa fa-martini-glass-empty",
	            "Mask" => "fa fa-mask",
	            "Mask Face" => "fa fa-mask-face",
	            "Mask Ventilator" => "fa fa-mask-ventilator",
	            "Masks Theater" => "fa fa-masks-theater",
	            "Mastodon" => "fab fa-mastodon",
	            "Mattress Pillow" => "fa fa-mattress-pillow",
	            "MaxCDN" => "fab fa-maxcdn",
	            "Maximize" => "fa fa-maximize",
	            "Material Design For Bootstrap" => "fab fa-mdb",
	            "Medal" => "fa fa-medal",
	            "MedApps" => "fab fa-medapps",
	            "Medium" => "fab fa-medium",
	            "MRT" => "fab fa-medrt",
	            "Meetup" => "fab fa-meetup",
	            "Megaport" => "fab fa-megaport",
	            "Memory" => "fa fa-memory",
	            "Mendeley" => "fab fa-mendeley",
	            "Menorah" => "fa fa-menorah",
	            "Mercury" => "fa fa-mercury",
	            "Message" => "fa fa-message",
	            "Meta" => "fab fa-meta",
	            "Meteor" => "fa fa-meteor",
	            "Micro.blog" => "fab fa-microblog",
	            "Microchip" => "fa fa-microchip",
	            "Microphone" => "fa fa-microphone",
	            "Microphone Lines" => "fa fa-microphone-lines",
	            "Microphone Lines Slash" => "fa fa-microphone-lines-slash",
	            "Microphone Slash" => "fa fa-microphone-slash",
	            "Microscope" => "fa fa-microscope",
	            "Microsoft" => "fab fa-microsoft",
	            "Mill Sign" => "fa fa-mill-sign",
	            "Minimize" => "fa fa-minimize",
	            "Minus" => "fa fa-minus",
	            "Mitten" => "fa fa-mitten",
	            "Mix" => "fab fa-mix",
	            "Mixcloud" => "fab fa-mixcloud",
	            "Mixer" => "fab fa-mixer",
	            "Mizuni" => "fab fa-mizuni",
	            "Mobile" => "fa fa-mobile",
	            "Mobile Button" => "fa fa-mobile-button",
	            "Mobile Retro" => "fa fa-mobile-retro",
	            "Mobile Screen" => "fa fa-mobile-screen",
	            "Mobile Screen Button" => "fa fa-mobile-screen-button",
	            "MODX" => "fab fa-modx",
	            "Monero" => "fab fa-monero",
	            "Money Bill" => "fa fa-money-bill",
	            "Money Bill 1" => "fa fa-money-bill-1",
	            "Money Bill 1 Wave" => "fa fa-money-bill-1-wave",
	            "Money Bill Transfer" => "fa fa-money-bill-transfer",
	            "Money Bill Trend Up" => "fa fa-money-bill-trend-up",
	            "Money Bill Wave" => "fa fa-money-bill-wave",
	            "Money Bill Wheat" => "fa fa-money-bill-wheat",
	            "Money Bills" => "fa fa-money-bills",
	            "Money Check" => "fa fa-money-check",
	            "Money Check Dollar" => "fa fa-money-check-dollar",
	            "Monument" => "fa fa-monument",
	            "Moon" => "fa fa-moon",
	            "Mortar Pestle" => "fa fa-mortar-pestle",
	            "Mosque" => "fa fa-mosque",
	            "Mosquito" => "fa fa-mosquito",
	            "Mosquito Net" => "fa fa-mosquito-net",
	            "Motorcycle" => "fa fa-motorcycle",
	            "Mound" => "fa fa-mound",
	            "Mountain" => "fa fa-mountain",
	            "Mountain City" => "fa fa-mountain-city",
	            "Mountain Sun" => "fa fa-mountain-sun",
	            "Mug Hot" => "fa fa-mug-hot",
	            "Mug Saucer" => "fa fa-mug-saucer",
	            "Music" => "fa fa-music",
	            "N" => "fa fa-n",
	            "Naira Sign" => "fa fa-naira-sign",
	            "Napster" => "fab fa-napster",
	            "Neos" => "fab fa-neos",
	            "Network Wired" => "fa fa-network-wired",
	            "Neuter" => "fa fa-neuter",
	            "Newspaper" => "fa fa-newspaper",
	            "NFC Directional" => "fab fa-nfc-directional",
	            "Nfc Symbol" => "fab fa-nfc-symbol",
	            "Nimblr" => "fab fa-nimblr",
	            "Node.js" => "fab fa-node",
	            "Node.js JS" => "fab fa-node-js",
	            "Not Equal" => "fa fa-not-equal",
	            "Notdef" => "fa fa-notdef",
	            "Note Sticky" => "fa fa-note-sticky",
	            "Notes Medical" => "fa fa-notes-medical",
	            "Npm" => "fab fa-npm",
	            "NS8" => "fab fa-ns8",
	            "Nutritionix" => "fab fa-nutritionix",
	            "O" => "fa fa-o",
	            "Object Group" => "fa fa-object-group",
	            "Object Ungroup" => "fa fa-object-ungroup",
	            "Octopus Deploy" => "fab fa-octopus-deploy",
	            "Odnoklassniki" => "fab fa-odnoklassniki",
	            "Odysee" => "fab fa-odysee",
	            "Oil Can" => "fa fa-oil-can",
	            "Oil Well" => "fa fa-oil-well",
	            "Old Republic" => "fab fa-old-republic",
	            "Om" => "fa fa-om",
	            "OpenCart" => "fab fa-opencart",
	            "OpenID" => "fab fa-openid",
	            "Opera" => "fab fa-opera",
	            "Optin Monster" => "fab fa-optin-monster",
	            "ORCID" => "fab fa-orcid",
	            "Open Source Initiative" => "fab fa-osi",
	            "Otter" => "fa fa-otter",
	            "Outdent" => "fa fa-outdent",
	            "P" => "fa fa-p",
	            "Padlet" => "fab fa-padlet",
	            "Page4 Corporation" => "fab fa-page4",
	            "Pagelines" => "fab fa-pagelines",
	            "Pager" => "fa fa-pager",
	            "Paint Roller" => "fa fa-paint-roller",
	            "Paintbrush" => "fa fa-paintbrush",
	            "Palette" => "fa fa-palette",
	            "Palfed" => "fab fa-palfed",
	            "Pallet" => "fa fa-pallet",
	            "Panorama" => "fa fa-panorama",
	            "Paper Plane" => "fa fa-paper-plane",
	            "Paperclip" => "fa fa-paperclip",
	            "Parachute Box" => "fa fa-parachute-box",
	            "Paragraph" => "fa fa-paragraph",
	            "Passport" => "fa fa-passport",
	            "Paste" => "fa fa-paste",
	            "Patreon" => "fab fa-patreon",
	            "Pause" => "fa fa-pause",
	            "Paw" => "fa fa-paw",
	            "Paypal" => "fab fa-paypal",
	            "Peace" => "fa fa-peace",
	            "Pen" => "fa fa-pen",
	            "Pen Clip" => "fa fa-pen-clip",
	            "Pen Fancy" => "fa fa-pen-fancy",
	            "Pen Nib" => "fa fa-pen-nib",
	            "Pen Ruler" => "fa fa-pen-ruler",
	            "Pen To Square" => "fa fa-pen-to-square",
	            "Pencil" => "fa fa-pencil",
	            "People Arrows" => "fa fa-people-arrows",
	            "People Carry Box" => "fa fa-people-carry-box",
	            "People Group" => "fa fa-people-group",
	            "People Line" => "fa fa-people-line",
	            "People Pulling" => "fa fa-people-pulling",
	            "People Robbery" => "fa fa-people-robbery",
	            "People Roof" => "fa fa-people-roof",
	            "Pepper Hot" => "fa fa-pepper-hot",
	            "PerByte" => "fab fa-perbyte",
	            "Percent" => "fa fa-percent",
	            "Periscope" => "fab fa-periscope",
	            "Person" => "fa fa-person",
	            "Person Arrow Down To Line" => "fa fa-person-arrow-down-to-line",
	            "Person Arrow Up From Line" => "fa fa-person-arrow-up-from-line",
	            "Person Biking" => "fa fa-person-biking",
	            "Person Booth" => "fa fa-person-booth",
	            "Person Breastfeeding" => "fa fa-person-breastfeeding",
	            "Person Burst" => "fa fa-person-burst",
	            "Person Cane" => "fa fa-person-cane",
	            "Person Chalkboard" => "fa fa-person-chalkboard",
	            "Person Circle Check" => "fa fa-person-circle-check",
	            "Person Circle Exclamation" => "fa fa-person-circle-exclamation",
	            "Person Circle Minus" => "fa fa-person-circle-minus",
	            "Person Circle Plus" => "fa fa-person-circle-plus",
	            "Person Circle Question" => "fa fa-person-circle-question",
	            "Person Circle Xmark" => "fa fa-person-circle-xmark",
	            "Person Digging" => "fa fa-person-digging",
	            "Person Dots From Line" => "fa fa-person-dots-from-line",
	            "Person Dress" => "fa fa-person-dress",
	            "Person Dress Burst" => "fa fa-person-dress-burst",
	            "Person Drowning" => "fa fa-person-drowning",
	            "Person Falling" => "fa fa-person-falling",
	            "Person Falling Burst" => "fa fa-person-falling-burst",
	            "Person Half Dress" => "fa fa-person-half-dress",
	            "Person Harassing" => "fa fa-person-harassing",
	            "Person Hiking" => "fa fa-person-hiking",
	            "Person Military Pointing" => "fa fa-person-military-pointing",
	            "Person Military Rifle" => "fa fa-person-military-rifle",
	            "Person Military To Person" => "fa fa-person-military-to-person",
	            "Person Praying" => "fa fa-person-praying",
	            "Person Pregnant" => "fa fa-person-pregnant",
	            "Person Rays" => "fa fa-person-rays",
	            "Person Rifle" => "fa fa-person-rifle",
	            "Person Running" => "fa fa-person-running",
	            "Person Shelter" => "fa fa-person-shelter",
	            "Person Skating" => "fa fa-person-skating",
	            "Person Skiing" => "fa fa-person-skiing",
	            "Person Skiing Nordic" => "fa fa-person-skiing-nordic",
	            "Person Snowboarding" => "fa fa-person-snowboarding",
	            "Person Swimming" => "fa fa-person-swimming",
	            "Person Through Window" => "fa fa-person-through-window",
	            "Person Walking" => "fa fa-person-walking",
	            "Person Walking Arrow Loop Left" => "fa fa-person-walking-arrow-loop-left",
	            "Person Walking Arrow Right" => "fa fa-person-walking-arrow-right",
	            "Person Walking Dashed Line Arrow Right" => "fa fa-person-walking-dashed-line-arrow-right",
	            "Person Walking Luggage" => "fa fa-person-walking-luggage",
	            "Person Walking With Cane" => "fa fa-person-walking-with-cane",
	            "Peseta Sign" => "fa fa-peseta-sign",
	            "Peso Sign" => "fa fa-peso-sign",
	            "Phabricator" => "fab fa-phabricator",
	            "Phoenix Framework" => "fab fa-phoenix-framework",
	            "Phoenix Squadron" => "fab fa-phoenix-squadron",
	            "Phone" => "fa fa-phone",
	            "Phone Flip" => "fa fa-phone-flip",
	            "Phone Slash" => "fa fa-phone-slash",
	            "Phone Volume" => "fa fa-phone-volume",
	            "Photo Film" => "fa fa-photo-film",
	            "PHP" => "fab fa-php",
	            "Pied Piper Logo" => "fab fa-pied-piper",
	            "Alternate Pied Piper Logo (Old)" => "fab fa-pied-piper-alt",
	            "Pied Piper Hat (Old)" => "fab fa-pied-piper-hat",
	            "Pied Piper PP Logo (Old)" => "fab fa-pied-piper-pp",
	            "Piggy Bank" => "fa fa-piggy-bank",
	            "Pills" => "fa fa-pills",
	            "Pinterest" => "fab fa-pinterest",
	            "Pinterest P" => "fab fa-pinterest-p",
	            "Pix" => "fab fa-pix",
	            "Pizza Slice" => "fa fa-pizza-slice",
	            "Place Of Worship" => "fa fa-place-of-worship",
	            "Plane" => "fa fa-plane",
	            "Plane Arrival" => "fa fa-plane-arrival",
	            "Plane Circle Check" => "fa fa-plane-circle-check",
	            "Plane Circle Exclamation" => "fa fa-plane-circle-exclamation",
	            "Plane Circle Xmark" => "fa fa-plane-circle-xmark",
	            "Plane Departure" => "fa fa-plane-departure",
	            "Plane Lock" => "fa fa-plane-lock",
	            "Plane Slash" => "fa fa-plane-slash",
	            "Plane Up" => "fa fa-plane-up",
	            "Plant Wilt" => "fa fa-plant-wilt",
	            "Plate Wheat" => "fa fa-plate-wheat",
	            "Play" => "fa fa-play",
	            "PlayStation" => "fab fa-playstation",
	            "Plug" => "fa fa-plug",
	            "Plug Circle Bolt" => "fa fa-plug-circle-bolt",
	            "Plug Circle Check" => "fa fa-plug-circle-check",
	            "Plug Circle Exclamation" => "fa fa-plug-circle-exclamation",
	            "Plug Circle Minus" => "fa fa-plug-circle-minus",
	            "Plug Circle Plus" => "fa fa-plug-circle-plus",
	            "Plug Circle Xmark" => "fa fa-plug-circle-xmark",
	            "Plus" => "fa fa-plus",
	            "Plus Minus" => "fa fa-plus-minus",
	            "Podcast" => "fa fa-podcast",
	            "Poo" => "fa fa-poo",
	            "Poo Storm" => "fa fa-poo-storm",
	            "Poop" => "fa fa-poop",
	            "Power Off" => "fa fa-power-off",
	            "Prescription" => "fa fa-prescription",
	            "Prescription Bottle" => "fa fa-prescription-bottle",
	            "Prescription Bottle Medical" => "fa fa-prescription-bottle-medical",
	            "Print" => "fa fa-print",
	            "Product Hunt" => "fab fa-product-hunt",
	            "Pump Medical" => "fa fa-pump-medical",
	            "Pump Soap" => "fa fa-pump-soap",
	            "Pushed" => "fab fa-pushed",
	            "Puzzle Piece" => "fa fa-puzzle-piece",
	            "Python" => "fab fa-python",
	            "Q" => "fa fa-q",
	            "QQ" => "fab fa-qq",
	            "Qrcode" => "fa fa-qrcode",
	            "Question" => "fa fa-question",
	            "QuinScape" => "fab fa-quinscape",
	            "Quora" => "fab fa-quora",
	            "Quote Left" => "fa fa-quote-left",
	            "Quote Right" => "fa fa-quote-right",
	            "R" => "fa fa-r",
	            "R Project" => "fab fa-r-project",
	            "Radiation" => "fa fa-radiation",
	            "Radio" => "fa fa-radio",
	            "Rainbow" => "fa fa-rainbow",
	            "Ranking Star" => "fa fa-ranking-star",
	            "Raspberry Pi" => "fab fa-raspberry-pi",
	            "Ravelry" => "fab fa-ravelry",
	            "React" => "fab fa-react",
	            "ReactEurope" => "fab fa-reacteurope",
	            "ReadMe" => "fab fa-readme",
	            "Rebel Alliance" => "fab fa-rebel",
	            "Receipt" => "fa fa-receipt",
	            "Record Vinyl" => "fa fa-record-vinyl",
	            "Rectangle Ad" => "fa fa-rectangle-ad",
	            "Rectangle List" => "fa fa-rectangle-list",
	            "Rectangle Xmark" => "fa fa-rectangle-xmark",
	            "Recycle" => "fa fa-recycle",
	            "Red River" => "fab fa-red-river",
	            "Reddit Logo" => "fab fa-reddit",
	            "Reddit Alien" => "fab fa-reddit-alien",
	            "Redhat" => "fab fa-redhat",
	            "Registered" => "fa fa-registered",
	            "Renren" => "fab fa-renren",
	            "Repeat" => "fa fa-repeat",
	            "Reply" => "fa fa-reply",
	            "Reply All" => "fa fa-reply-all",
	            "Replyd" => "fab fa-replyd",
	            "Republican" => "fa fa-republican",
	            "Researchgate" => "fab fa-researchgate",
	            "Resolving" => "fab fa-resolving",
	            "Restroom" => "fa fa-restroom",
	            "Retweet" => "fa fa-retweet",
	            "Rev.io" => "fab fa-rev",
	            "Ribbon" => "fa fa-ribbon",
	            "Right From Bracket" => "fa fa-right-from-bracket",
	            "Right Left" => "fa fa-right-left",
	            "Right Long" => "fa fa-right-long",
	            "Right To Bracket" => "fa fa-right-to-bracket",
	            "Ring" => "fa fa-ring",
	            "Road" => "fa fa-road",
	            "Road Barrier" => "fa fa-road-barrier",
	            "Road Bridge" => "fa fa-road-bridge",
	            "Road Circle Check" => "fa fa-road-circle-check",
	            "Road Circle Exclamation" => "fa fa-road-circle-exclamation",
	            "Road Circle Xmark" => "fa fa-road-circle-xmark",
	            "Road Lock" => "fa fa-road-lock",
	            "Road Spikes" => "fa fa-road-spikes",
	            "Robot" => "fa fa-robot",
	            "Rocket" => "fa fa-rocket",
	            "Rocket.Chat" => "fab fa-rocketchat",
	            "Rockrms" => "fab fa-rockrms",
	            "Rotate" => "fa fa-rotate",
	            "Rotate Left" => "fa fa-rotate-left",
	            "Rotate Right" => "fa fa-rotate-right",
	            "Route" => "fa fa-route",
	            "Rss" => "fa fa-rss",
	            "Ruble Sign" => "fa fa-ruble-sign",
	            "Rug" => "fa fa-rug",
	            "Ruler" => "fa fa-ruler",
	            "Ruler Combined" => "fa fa-ruler-combined",
	            "Ruler Horizontal" => "fa fa-ruler-horizontal",
	            "Ruler Vertical" => "fa fa-ruler-vertical",
	            "Rupee Sign" => "fa fa-rupee-sign",
	            "Rupiah Sign" => "fa fa-rupiah-sign",
	            "Rust" => "fab fa-rust",
	            "S" => "fa fa-s",
	            "Sack Dollar" => "fa fa-sack-dollar",
	            "Sack Xmark" => "fa fa-sack-xmark",
	            "Safari" => "fab fa-safari",
	            "Sailboat" => "fa fa-sailboat",
	            "Salesforce" => "fab fa-salesforce",
	            "Sass" => "fab fa-sass",
	            "Satellite" => "fa fa-satellite",
	            "Satellite Dish" => "fa fa-satellite-dish",
	            "Scale Balanced" => "fa fa-scale-balanced",
	            "Scale Unbalanced" => "fa fa-scale-unbalanced",
	            "Scale Unbalanced Flip" => "fa fa-scale-unbalanced-flip",
	            "SCHLIX" => "fab fa-schlix",
	            "School" => "fa fa-school",
	            "School Circle Check" => "fa fa-school-circle-check",
	            "School Circle Exclamation" => "fa fa-school-circle-exclamation",
	            "School Circle Xmark" => "fa fa-school-circle-xmark",
	            "School Flag" => "fa fa-school-flag",
	            "School Lock" => "fa fa-school-lock",
	            "Scissors" => "fa fa-scissors",
	            "Screenpal" => "fab fa-screenpal",
	            "Screwdriver" => "fa fa-screwdriver",
	            "Screwdriver Wrench" => "fa fa-screwdriver-wrench",
	            "Scribd" => "fab fa-scribd",
	            "Scroll" => "fa fa-scroll",
	            "Scroll Torah" => "fa fa-scroll-torah",
	            "Sd Card" => "fa fa-sd-card",
	            "Searchengin" => "fab fa-searchengin",
	            "Section" => "fa fa-section",
	            "Seedling" => "fa fa-seedling",
	            "Sellcast" => "fab fa-sellcast",
	            "Sellsy" => "fab fa-sellsy",
	            "Server" => "fa fa-server",
	            "Servicestack" => "fab fa-servicestack",
	            "Shapes" => "fa fa-shapes",
	            "Share" => "fa fa-share",
	            "Share From Square" => "fa fa-share-from-square",
	            "Share Nodes" => "fa fa-share-nodes",
	            "Sheet Plastic" => "fa fa-sheet-plastic",
	            "Shekel Sign" => "fa fa-shekel-sign",
	            "Shield" => "fa fa-shield",
	            "Shield Cat" => "fa fa-shield-cat",
	            "Shield Dog" => "fa fa-shield-dog",
	            "Shield Halved" => "fa fa-shield-halved",
	            "Shield Heart" => "fa fa-shield-heart",
	            "Shield Virus" => "fa fa-shield-virus",
	            "Ship" => "fa fa-ship",
	            "Shirt" => "fa fa-shirt",
	            "Shirts In Bulk" => "fab fa-shirtsinbulk",
	            "Shoe Prints" => "fa fa-shoe-prints",
	            "Shop" => "fa fa-shop",
	            "Shop Lock" => "fa fa-shop-lock",
	            "Shop Slash" => "fa fa-shop-slash",
	            "Shopify" => "fab fa-shopify",
	            "Shopware" => "fab fa-shopware",
	            "Shower" => "fa fa-shower",
	            "Shrimp" => "fa fa-shrimp",
	            "Shuffle" => "fa fa-shuffle",
	            "Shuttle Space" => "fa fa-shuttle-space",
	            "Sign Hanging" => "fa fa-sign-hanging",
	            "Signal" => "fa fa-signal",
	            "Signature" => "fa fa-signature",
	            "Signs Post" => "fa fa-signs-post",
	            "Sim Card" => "fa fa-sim-card",
	            "SimplyBuilt" => "fab fa-simplybuilt",
	            "Sink" => "fa fa-sink",
	            "SISTRIX" => "fab fa-sistrix",
	            "Sitemap" => "fa fa-sitemap",
	            "Sith" => "fab fa-sith",
	            "Sitrox" => "fab fa-sitrox",
	            "Sketch" => "fab fa-sketch",
	            "Skull" => "fa fa-skull",
	            "Skull Crossbones" => "fa fa-skull-crossbones",
	            "Skyatlas" => "fab fa-skyatlas",
	            "Skype" => "fab fa-skype",
	            "Slack Logo" => "fab fa-slack",
	            "Slash" => "fa fa-slash",
	            "Sleigh" => "fa fa-sleigh",
	            "Sliders" => "fa fa-sliders",
	            "Slideshare" => "fab fa-slideshare",
	            "Smog" => "fa fa-smog",
	            "Smoking" => "fa fa-smoking",
	            "Snapchat" => "fab fa-snapchat",
	            "Snowflake" => "fa fa-snowflake",
	            "Snowman" => "fa fa-snowman",
	            "Snowplow" => "fa fa-snowplow",
	            "Soap" => "fa fa-soap",
	            "Socks" => "fa fa-socks",
	            "Solar Panel" => "fa fa-solar-panel",
	            "Sort" => "fa fa-sort",
	            "Sort Down" => "fa fa-sort-down",
	            "Sort Up" => "fa fa-sort-up",
	            "SoundCloud" => "fab fa-soundcloud",
	            "Sourcetree" => "fab fa-sourcetree",
	            "Spa" => "fa fa-spa",
	            "Space Awesome" => "fab fa-space-awesome",
	            "Spaghetti Monster Flying" => "fa fa-spaghetti-monster-flying",
	            "Speakap" => "fab fa-speakap",
	            "Speaker Deck" => "fab fa-speaker-deck",
	            "Spell Check" => "fa fa-spell-check",
	            "Spider" => "fa fa-spider",
	            "Spinner" => "fa fa-spinner",
	            "Splotch" => "fa fa-splotch",
	            "Spoon" => "fa fa-spoon",
	            "Spotify" => "fab fa-spotify",
	            "Spray Can" => "fa fa-spray-can",
	            "Spray Can Sparkles" => "fa fa-spray-can-sparkles",
	            "Square" => "fa fa-square",
	            "Square Arrow Up Right" => "fa fa-square-arrow-up-right",
	            "Behance Square" => "fab fa-square-behance",
	            "Square Caret Down" => "fa fa-square-caret-down",
	            "Square Caret Left" => "fa fa-square-caret-left",
	            "Square Caret Right" => "fa fa-square-caret-right",
	            "Square Caret Up" => "fa fa-square-caret-up",
	            "Square Check" => "fa fa-square-check",
	            "Dribbble Square" => "fab fa-square-dribbble",
	            "Square Envelope" => "fa fa-square-envelope",
	            "Facebook Square" => "fab fa-square-facebook",
	            "Font Awesome In Square" => "fab fa-square-font-awesome",
	            "Font Awesome In Square With Stroke Outline" => "fab fa-square-font-awesome-stroke",
	            "Square Full" => "fa fa-square-full",
	            "Git Square" => "fab fa-square-git",
	            "GitHub Square" => "fab fa-square-github",
	            "Square Gitlab" => "fab fa-square-gitlab",
	            "Google Plus Square" => "fab fa-square-google-plus",
	            "Square H" => "fa fa-square-h",
	            "Hacker News Square" => "fab fa-square-hacker-news",
	            "Instagram Square" => "fab fa-square-instagram",
	            "JavaScript (JS) Square" => "fab fa-square-js",
	            "Last.fm Square" => "fab fa-square-lastfm",
	            "Square Minus" => "fa fa-square-minus",
	            "Square Nfi" => "fa fa-square-nfi",
	            "Odnoklassniki Square" => "fab fa-square-odnoklassniki",
	            "Square Parking" => "fa fa-square-parking",
	            "Square Pen" => "fa fa-square-pen",
	            "Square Person Confined" => "fa fa-square-person-confined",
	            "Square Phone" => "fa fa-square-phone",
	            "Square Phone Flip" => "fa fa-square-phone-flip",
	            "Pied Piper Square Logo (Old)" => "fab fa-square-pied-piper",
	            "Pinterest Square" => "fab fa-square-pinterest",
	            "Square Plus" => "fa fa-square-plus",
	            "Square Poll Horizontal" => "fa fa-square-poll-horizontal",
	            "Square Poll Vertical" => "fa fa-square-poll-vertical",
	            "Reddit Square" => "fab fa-square-reddit",
	            "Square Root Variable" => "fa fa-square-root-variable",
	            "Square Rss" => "fa fa-square-rss",
	            "Square Share Nodes" => "fa fa-square-share-nodes",
	            "Snapchat Square" => "fab fa-square-snapchat",
	            "Steam Square" => "fab fa-square-steam",
	            "Square Threads" => "fab fa-square-threads",
	            "Tumblr Square" => "fab fa-square-tumblr",
	            "Square Twitter" => "fab fa-square-twitter",
	            "Square Up Right" => "fa fa-square-up-right",
	            "Viadeo Square" => "fab fa-square-viadeo",
	            "Vimeo Square" => "fab fa-square-vimeo",
	            "Square Virus" => "fa fa-square-virus",
	            "What&#039;s App Square" => "fab fa-square-whatsapp",
	            "Square X Twitter" => "fab fa-square-x-twitter",
	            "Xing Square" => "fab fa-square-xing",
	            "Square Xmark" => "fa fa-square-xmark",
	            "YouTube Square" => "fab fa-square-youtube",
	            "Squarespace" => "fab fa-squarespace",
	            "Stack Exchange" => "fab fa-stack-exchange",
	            "Stack Overflow" => "fab fa-stack-overflow",
	            "Stackpath" => "fab fa-stackpath",
	            "Staff Snake" => "fa fa-staff-snake",
	            "Stairs" => "fa fa-stairs",
	            "Stamp" => "fa fa-stamp",
	            "Stapler" => "fa fa-stapler",
	            "Star" => "fa fa-star",
	            "Star And Crescent" => "fa fa-star-and-crescent",
	            "Star Half" => "fa fa-star-half",
	            "Star Half Stroke" => "fa fa-star-half-stroke",
	            "Star Of David" => "fa fa-star-of-david",
	            "Star Of Life" => "fa fa-star-of-life",
	            "StayLinked" => "fab fa-staylinked",
	            "Steam" => "fab fa-steam",
	            "Steam Symbol" => "fab fa-steam-symbol",
	            "Sterling Sign" => "fa fa-sterling-sign",
	            "Stethoscope" => "fa fa-stethoscope",
	            "Sticker Mule" => "fab fa-sticker-mule",
	            "Stop" => "fa fa-stop",
	            "Stopwatch" => "fa fa-stopwatch",
	            "Stopwatch 20" => "fa fa-stopwatch-20",
	            "Store" => "fa fa-store",
	            "Store Slash" => "fa fa-store-slash",
	            "Strava" => "fab fa-strava",
	            "Street View" => "fa fa-street-view",
	            "Strikethrough" => "fa fa-strikethrough",
	            "Stripe" => "fab fa-stripe",
	            "Stripe S" => "fab fa-stripe-s",
	            "Stroopwafel" => "fa fa-stroopwafel",
	            "Stubber" => "fab fa-stubber",
	            "Studio Vinari" => "fab fa-studiovinari",
	            "StumbleUpon Logo" => "fab fa-stumbleupon",
	            "StumbleUpon Circle" => "fab fa-stumbleupon-circle",
	            "Subscript" => "fa fa-subscript",
	            "Suitcase" => "fa fa-suitcase",
	            "Suitcase Medical" => "fa fa-suitcase-medical",
	            "Suitcase Rolling" => "fa fa-suitcase-rolling",
	            "Sun" => "fa fa-sun",
	            "Sun Plant Wilt" => "fa fa-sun-plant-wilt",
	            "Superpowers" => "fab fa-superpowers",
	            "Superscript" => "fa fa-superscript",
	            "Supple" => "fab fa-supple",
	            "Suse" => "fab fa-suse",
	            "Swatchbook" => "fa fa-swatchbook",
	            "Swift" => "fab fa-swift",
	            "Symfony" => "fab fa-symfony",
	            "Synagogue" => "fa fa-synagogue",
	            "Syringe" => "fa fa-syringe",
	            "T" => "fa fa-t",
	            "Table" => "fa fa-table",
	            "Table Cells" => "fa fa-table-cells",
	            "Table Cells Large" => "fa fa-table-cells-large",
	            "Table Columns" => "fa fa-table-columns",
	            "Table List" => "fa fa-table-list",
	            "Table Tennis Paddle Ball" => "fa fa-table-tennis-paddle-ball",
	            "Tablet" => "fa fa-tablet",
	            "Tablet Button" => "fa fa-tablet-button",
	            "Tablet Screen Button" => "fa fa-tablet-screen-button",
	            "Tablets" => "fa fa-tablets",
	            "Tachograph Digital" => "fa fa-tachograph-digital",
	            "Tag" => "fa fa-tag",
	            "Tags" => "fa fa-tags",
	            "Tape" => "fa fa-tape",
	            "Tarp" => "fa fa-tarp",
	            "Tarp Droplet" => "fa fa-tarp-droplet",
	            "Taxi" => "fa fa-taxi",
	            "Teamspeak" => "fab fa-teamspeak",
	            "Teeth" => "fa fa-teeth",
	            "Teeth Open" => "fa fa-teeth-open",
	            "Telegram" => "fab fa-telegram",
	            "Temperature Arrow Down" => "fa fa-temperature-arrow-down",
	            "Temperature Arrow Up" => "fa fa-temperature-arrow-up",
	            "Temperature Empty" => "fa fa-temperature-empty",
	            "Temperature Full" => "fa fa-temperature-full",
	            "Temperature Half" => "fa fa-temperature-half",
	            "Temperature High" => "fa fa-temperature-high",
	            "Temperature Low" => "fa fa-temperature-low",
	            "Temperature Quarter" => "fa fa-temperature-quarter",
	            "Temperature Three Quarters" => "fa fa-temperature-three-quarters",
	            "Tencent Weibo" => "fab fa-tencent-weibo",
	            "Tenge Sign" => "fa fa-tenge-sign",
	            "Tent" => "fa fa-tent",
	            "Tent Arrow Down To Line" => "fa fa-tent-arrow-down-to-line",
	            "Tent Arrow Left Right" => "fa fa-tent-arrow-left-right",
	            "Tent Arrow Turn Left" => "fa fa-tent-arrow-turn-left",
	            "Tent Arrows Down" => "fa fa-tent-arrows-down",
	            "Tents" => "fa fa-tents",
	            "Terminal" => "fa fa-terminal",
	            "Text Height" => "fa fa-text-height",
	            "Text Slash" => "fa fa-text-slash",
	            "Text Width" => "fa fa-text-width",
	            "The Red Yeti" => "fab fa-the-red-yeti",
	            "Themeco" => "fab fa-themeco",
	            "ThemeIsle" => "fab fa-themeisle",
	            "Thermometer" => "fa fa-thermometer",
	            "Think Peaks" => "fab fa-think-peaks",
	            "Threads" => "fab fa-threads",
	            "Thumbs Down" => "fa fa-thumbs-down",
	            "Thumbs Up" => "fa fa-thumbs-up",
	            "Thumbtack" => "fa fa-thumbtack",
	            "Ticket" => "fa fa-ticket",
	            "Ticket Simple" => "fa fa-ticket-simple",
	            "TikTok" => "fab fa-tiktok",
	            "Timeline" => "fa fa-timeline",
	            "Toggle Off" => "fa fa-toggle-off",
	            "Toggle On" => "fa fa-toggle-on",
	            "Toilet" => "fa fa-toilet",
	            "Toilet Paper" => "fa fa-toilet-paper",
	            "Toilet Paper Slash" => "fa fa-toilet-paper-slash",
	            "Toilet Portable" => "fa fa-toilet-portable",
	            "Toilets Portable" => "fa fa-toilets-portable",
	            "Toolbox" => "fa fa-toolbox",
	            "Tooth" => "fa fa-tooth",
	            "Torii Gate" => "fa fa-torii-gate",
	            "Tornado" => "fa fa-tornado",
	            "Tower Broadcast" => "fa fa-tower-broadcast",
	            "Tower Cell" => "fa fa-tower-cell",
	            "Tower Observation" => "fa fa-tower-observation",
	            "Tractor" => "fa fa-tractor",
	            "Trade Federation" => "fab fa-trade-federation",
	            "Trademark" => "fa fa-trademark",
	            "Traffic Light" => "fa fa-traffic-light",
	            "Trailer" => "fa fa-trailer",
	            "Train" => "fa fa-train",
	            "Train Subway" => "fa fa-train-subway",
	            "Train Tram" => "fa fa-train-tram",
	            "Transgender" => "fa fa-transgender",
	            "Trash" => "fa fa-trash",
	            "Trash Arrow Up" => "fa fa-trash-arrow-up",
	            "Trash Can" => "fa fa-trash-can",
	            "Trash Can Arrow Up" => "fa fa-trash-can-arrow-up",
	            "Tree" => "fa fa-tree",
	            "Tree City" => "fa fa-tree-city",
	            "Trello" => "fab fa-trello",
	            "Triangle Exclamation" => "fa fa-triangle-exclamation",
	            "Trophy" => "fa fa-trophy",
	            "Trowel" => "fa fa-trowel",
	            "Trowel Bricks" => "fa fa-trowel-bricks",
	            "Truck" => "fa fa-truck",
	            "Truck Arrow Right" => "fa fa-truck-arrow-right",
	            "Truck Droplet" => "fa fa-truck-droplet",
	            "Truck Fast" => "fa fa-truck-fast",
	            "Truck Field" => "fa fa-truck-field",
	            "Truck Field Un" => "fa fa-truck-field-un",
	            "Truck Front" => "fa fa-truck-front",
	            "Truck Medical" => "fa fa-truck-medical",
	            "Truck Monster" => "fa fa-truck-monster",
	            "Truck Moving" => "fa fa-truck-moving",
	            "Truck Pickup" => "fa fa-truck-pickup",
	            "Truck Plane" => "fa fa-truck-plane",
	            "Truck Ramp Box" => "fa fa-truck-ramp-box",
	            "Tty" => "fa fa-tty",
	            "Tumblr" => "fab fa-tumblr",
	            "Turkish Lira Sign" => "fa fa-turkish-lira-sign",
	            "Turn Down" => "fa fa-turn-down",
	            "Turn Up" => "fa fa-turn-up",
	            "Tv" => "fa fa-tv",
	            "Twitch" => "fab fa-twitch",
	            "Twitter" => "fab fa-twitter",
	            "Typo3" => "fab fa-typo3",
	            "U" => "fa fa-u",
	            "Uber" => "fab fa-uber",
	            "Ubuntu" => "fab fa-ubuntu",
	            "UIkit" => "fab fa-uikit",
	            "Umbraco" => "fab fa-umbraco",
	            "Umbrella" => "fa fa-umbrella",
	            "Umbrella Beach" => "fa fa-umbrella-beach",
	            "Uncharted Software" => "fab fa-uncharted",
	            "Underline" => "fa fa-underline",
	            "Uniregistry" => "fab fa-uniregistry",
	            "Unity 3D" => "fab fa-unity",
	            "Universal Access" => "fa fa-universal-access",
	            "Unlock" => "fa fa-unlock",
	            "Unlock Keyhole" => "fa fa-unlock-keyhole",
	            "Unsplash" => "fab fa-unsplash",
	            "Untappd" => "fab fa-untappd",
	            "Up Down" => "fa fa-up-down",
	            "Up Down Left Right" => "fa fa-up-down-left-right",
	            "Up Long" => "fa fa-up-long",
	            "Up Right And Down Left From Center" => "fa fa-up-right-and-down-left-from-center",
	            "Up Right From Square" => "fa fa-up-right-from-square",
	            "Upload" => "fa fa-upload",
	            "UPS" => "fab fa-ups",
	            "USB" => "fab fa-usb",
	            "User" => "fa fa-user",
	            "User Astronaut" => "fa fa-user-astronaut",
	            "User Check" => "fa fa-user-check",
	            "User Clock" => "fa fa-user-clock",
	            "User Doctor" => "fa fa-user-doctor",
	            "User Gear" => "fa fa-user-gear",
	            "User Graduate" => "fa fa-user-graduate",
	            "User Group" => "fa fa-user-group",
	            "User Injured" => "fa fa-user-injured",
	            "User Large" => "fa fa-user-large",
	            "User Large Slash" => "fa fa-user-large-slash",
	            "User Lock" => "fa fa-user-lock",
	            "User Minus" => "fa fa-user-minus",
	            "User Ninja" => "fa fa-user-ninja",
	            "User Nurse" => "fa fa-user-nurse",
	            "User Pen" => "fa fa-user-pen",
	            "User Plus" => "fa fa-user-plus",
	            "User Secret" => "fa fa-user-secret",
	            "User Shield" => "fa fa-user-shield",
	            "User Slash" => "fa fa-user-slash",
	            "User Tag" => "fa fa-user-tag",
	            "User Tie" => "fa fa-user-tie",
	            "User Xmark" => "fa fa-user-xmark",
	            "Users" => "fa fa-users",
	            "Users Between Lines" => "fa fa-users-between-lines",
	            "Users Gear" => "fa fa-users-gear",
	            "Users Line" => "fa fa-users-line",
	            "Users Rays" => "fa fa-users-rays",
	            "Users Rectangle" => "fa fa-users-rectangle",
	            "Users Slash" => "fa fa-users-slash",
	            "Users Viewfinder" => "fa fa-users-viewfinder",
	            "United States Postal Service" => "fab fa-usps",
	            "Us-Sunnah Foundation" => "fab fa-ussunnah",
	            "Utensils" => "fa fa-utensils",
	            "V" => "fa fa-v",
	            "Vaadin" => "fab fa-vaadin",
	            "Van Shuttle" => "fa fa-van-shuttle",
	            "Vault" => "fa fa-vault",
	            "Vector Square" => "fa fa-vector-square",
	            "Venus" => "fa fa-venus",
	            "Venus Double" => "fa fa-venus-double",
	            "Venus Mars" => "fa fa-venus-mars",
	            "Vest" => "fa fa-vest",
	            "Vest Patches" => "fa fa-vest-patches",
	            "Viacoin" => "fab fa-viacoin",
	            "Viadeo" => "fab fa-viadeo",
	            "Vial" => "fa fa-vial",
	            "Vial Circle Check" => "fa fa-vial-circle-check",
	            "Vial Virus" => "fa fa-vial-virus",
	            "Vials" => "fa fa-vials",
	            "Viber" => "fab fa-viber",
	            "Video" => "fa fa-video",
	            "Video Slash" => "fa fa-video-slash",
	            "Vihara" => "fa fa-vihara",
	            "Vimeo" => "fab fa-vimeo",
	            "Vimeo" => "fab fa-vimeo-v",
	            "Vine" => "fab fa-vine",
	            "Virus" => "fa fa-virus",
	            "Virus Covid" => "fa fa-virus-covid",
	            "Virus Covid Slash" => "fa fa-virus-covid-slash",
	            "Virus Slash" => "fa fa-virus-slash",
	            "Viruses" => "fa fa-viruses",
	            "VK" => "fab fa-vk",
	            "VNV" => "fab fa-vnv",
	            "Voicemail" => "fa fa-voicemail",
	            "Volcano" => "fa fa-volcano",
	            "Volleyball" => "fa fa-volleyball",
	            "Volume High" => "fa fa-volume-high",
	            "Volume Low" => "fa fa-volume-low",
	            "Volume Off" => "fa fa-volume-off",
	            "Volume Xmark" => "fa fa-volume-xmark",
	            "Vr Cardboard" => "fa fa-vr-cardboard",
	            "Vue.js" => "fab fa-vuejs",
	            "W" => "fa fa-w",
	            "Walkie Talkie" => "fa fa-walkie-talkie",
	            "Wallet" => "fa fa-wallet",
	            "Wand Magic" => "fa fa-wand-magic",
	            "Wand Magic Sparkles" => "fa fa-wand-magic-sparkles",
	            "Wand Sparkles" => "fa fa-wand-sparkles",
	            "Warehouse" => "fa fa-warehouse",
	            "Watchman Monitoring" => "fab fa-watchman-monitoring",
	            "Water" => "fa fa-water",
	            "Water Ladder" => "fa fa-water-ladder",
	            "Wave Square" => "fa fa-wave-square",
	            "Waze" => "fab fa-waze",
	            "Weebly" => "fab fa-weebly",
	            "Weibo" => "fab fa-weibo",
	            "Weight Hanging" => "fa fa-weight-hanging",
	            "Weight Scale" => "fa fa-weight-scale",
	            "Weixin (WeChat)" => "fab fa-weixin",
	            "What&#039;s App" => "fab fa-whatsapp",
	            "Wheat Awn" => "fa fa-wheat-awn",
	            "Wheat Awn Circle Exclamation" => "fa fa-wheat-awn-circle-exclamation",
	            "Wheelchair" => "fa fa-wheelchair",
	            "Wheelchair Move" => "fa fa-wheelchair-move",
	            "Whiskey Glass" => "fa fa-whiskey-glass",
	            "WHMCS" => "fab fa-whmcs",
	            "Wifi" => "fa fa-wifi",
	            "Wikipedia W" => "fab fa-wikipedia-w",
	            "Wind" => "fa fa-wind",
	            "Window Maximize" => "fa fa-window-maximize",
	            "Window Minimize" => "fa fa-window-minimize",
	            "Window Restore" => "fa fa-window-restore",
	            "Windows" => "fab fa-windows",
	            "Wine Bottle" => "fa fa-wine-bottle",
	            "Wine Glass" => "fa fa-wine-glass",
	            "Wine Glass Empty" => "fa fa-wine-glass-empty",
	            "Wirsindhandwerk" => "fab fa-wirsindhandwerk",
	            "Wix" => "fab fa-wix",
	            "Wizards Of The Coast" => "fab fa-wizards-of-the-coast",
	            "Wodu" => "fab fa-wodu",
	            "Wolf Pack Battalion" => "fab fa-wolf-pack-battalion",
	            "Won Sign" => "fa fa-won-sign",
	            "WordPress Logo" => "fab fa-wordpress",
	            "Wordpress Simple" => "fab fa-wordpress-simple",
	            "Worm" => "fa fa-worm",
	            "WPBeginner" => "fab fa-wpbeginner",
	            "WPExplorer" => "fab fa-wpexplorer",
	            "WPForms" => "fab fa-wpforms",
	            "Wpressr" => "fab fa-wpressr",
	            "Wrench" => "fa fa-wrench",
	            "X" => "fa fa-x",
	            "X Ray" => "fa fa-x-ray",
	            "X Twitter" => "fab fa-x-twitter",
	            "Xbox" => "fab fa-xbox",
	            "Xing" => "fab fa-xing",
	            "Xmark" => "fa fa-xmark",
	            "Xmarks Lines" => "fa fa-xmarks-lines",
	            "Y" => "fa fa-y",
	            "Y Combinator" => "fab fa-y-combinator",
	            "Yahoo Logo" => "fab fa-yahoo",
	            "Yammer" => "fab fa-yammer",
	            "Yandex" => "fab fa-yandex",
	            "Yandex International" => "fab fa-yandex-international",
	            "Yarn" => "fab fa-yarn",
	            "Yelp" => "fab fa-yelp",
	            "Yen Sign" => "fa fa-yen-sign",
	            "Yin Yang" => "fa fa-yin-yang",
	            "Yoast" => "fab fa-yoast",
	            "YouTube" => "fab fa-youtube",
	            "Z" => "fa fa-z",
	            "Zhihu" => "fab fa-zhihu",
            )
        );

        $fa_icons = array();
        $fa_icons[""] = "";
        foreach ($this->icons as $key => $value) {
            $fa_icons[$key] = $key;
        }

        $this->icons = $fa_icons;
    }

    public function getIconsArray() {
        return $this->icons;
    }

    public function render($icon, $params = array()) {
        $html = '';
        extract($params);
        $iconAttributesString = '';
        $iconClass = '';
        if (isset($icon_attributes) && count($icon_attributes)) {
            foreach ($icon_attributes as $icon_attr_name => $icon_attr_val) {
                if ($icon_attr_name === 'class') {
                    $iconClass = $icon_attr_val;
                    unset($icon_attributes[$icon_attr_name]);
                } else {
                    $iconAttributesString .= $icon_attr_name . '="' . $icon_attr_val . '" ';
                }
            }
        }

        if (isset($before_icon) && $before_icon !== '') {
            $beforeIconAttrString = '';
            if (isset($before_icon_attributes) && count($before_icon_attributes)) {
                foreach ($before_icon_attributes as $before_icon_attr_name => $before_icon_attr_val) {
                    $beforeIconAttrString .= $before_icon_attr_name . '="' . $before_icon_attr_val . '" ';
                }
            }

            $html .= '<' . $before_icon . ' ' . $beforeIconAttrString . '>';
        }

        $html .= '<i class="qode_icon_font_awesome_5 fa5 ' . $icon . ' ' . $iconClass . '" ' . $iconAttributesString . '></i>';

        if (isset($before_icon) && $before_icon !== '') {
            $html .= '</' . $before_icon . '>';
        }

        return $html;
    }

    public function hasSocialIcons() {
        return false;
    }

    public function getSearchIcon($params = array()) {

        return $this->render('fa fa-search', $params);
    }

    public function getSearchClose($params = array()) {

        return $this->render('fa fa-times', $params);
    }

    public function getMenuSideIcon() {

        return $this->render('fa fa-bars');
    }

    public function hasBackToTopIcons()	{
        return true;
    }

    public function setBackToTopIconsArray() {
        $this->backTopTopIcons = array(
            ''                      => '',
            'fa fa-angle-up' => esc_html__('Angle Up', 'bridge'),
            'fa fa-angle-double-up' => esc_html__('Angle Double Up', 'bridge'),
            'fa fa-arrow-alt-circle-up' => esc_html__('Alt Circle Up', 'bridge'),
            'fa fa-chevron-up' => esc_html__('Chevron Up', 'bridge'),
            'fa fa-hand-point-up' => esc_html__('Hand Point Up', 'bridge'),
            'fa fa-level-up-alt' => esc_html__('Alt Level Up', 'bridge'),
            'fa fa-long-arrow-alt-up' => esc_html__('Alt Long Arrow Up', 'bridge'),
        );

        $fa_icons = array();
        $fa_icons[""] = "";
        foreach ($this->backTopTopIcons as $key => $value) {
            $fa_icons[$key] = $value;
        }

        $this->backTopTopIcons = $fa_icons;
    }

    public function getBackToTopIconsArray() {

        return $this->backTopTopIcons;
    }

    public function getMobileMenuIcon() {

        return $this->render('fa fa-bars');
    }

    public function getQuoteIcon() {

        return $this->render('fa fa-quote-left');
    }

    public function getSocialIconsArrayVC()	{

        return array();
    }

}