<?php
use QodeListing\Lib\Shortcodes;
use QodeListing\Lib\ElementorShortcodes;

if(!function_exists('qode_listing_categories_shortcode_helper')) {
	function qode_listing_categories_shortcode_helper($shortcodes_class_name) {

		$shortcodes = array(
			'QodeListing\Lib\Shortcodes\ListingCategories'
		);

		$shortcodes_class_name = array_merge($shortcodes_class_name, $shortcodes);

		return $shortcodes_class_name;
	}

	add_filter('qode_listing_filter_add_vc_shortcode', 'qode_listing_categories_shortcode_helper');
}

if(!function_exists('qode_listing_categories_class_instance')){

	function qode_listing_categories_class_instance(){
		return Shortcodes\ListingCategories::getInstance();
	}

}

if(!function_exists('qode_listing_elementor_categories_class_instance')){

	function qode_listing_elementor_categories_class_instance(){
		return ElementorShortcodes\QodeListingElementorListingCategories::getInstance();
	}

}

if( !function_exists('qode_listing_set_ls_categories_icon_class_name_for_vc_shortcodes') ) {
	/**
	 * Function that set custom icon class name for button shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function qode_listing_set_ls_categories_icon_class_name_for_vc_shortcodes($shortcodes_icon_class_array) {
		$shortcodes_icon_class_array[] = '.icon-wpb-ls-categories';

		return $shortcodes_icon_class_array;
	}

	add_filter('qode_core_filter_add_vc_shortcodes_custom_icon_class', 'qode_listing_set_ls_categories_icon_class_name_for_vc_shortcodes');
}

if( ! function_exists( 'qode_listing_add_listing_categories_shortcode_packery_script_for_wpb_shortcode_scripts_array' ) ) {
	function qode_listing_add_listing_categories_shortcode_packery_script_for_wpb_shortcode_scripts_array( $shortcodes_array ) {
		if( array_key_exists( 'packery', $shortcodes_array ) ) {
			$shortcodes_array['packery'] = array_merge( $shortcodes_array['packery'], array( 'qode_listing_cats' => false ) );
		} else {
			$shortcodes_array = array_merge(
				$shortcodes_array,
				array(
					'packery' => array(
						'qode_listing_cats' => false
					)
				)
			);
		}
		
		return $shortcodes_array;
	}
	
	add_filter( 'bridge_qode_filter_wpb_shortcode_scripts_array', 'qode_listing_add_listing_categories_shortcode_packery_script_for_wpb_shortcode_scripts_array' );
}