<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Qi_Blocks_Call_To_Action_Block' ) ) {
	class Qi_Blocks_Call_To_Action_Block extends Qi_Blocks_Blocks {
		private static $instance;

		public function __construct() {
			// Set block data
			$this->set_block_name( 'call-to-action' );
			$this->set_block_title( esc_html__( 'Call to Action', 'qi-blocks' ) );
			$this->set_block_subcategory( esc_html__( 'Typography', 'qi-blocks' ) );
			$this->set_block_demo_url( 'https://qodeinteractive.com/qi-blocks-for-gutenberg/call-to-action/' );
			$this->set_block_documentation( 'https://qodeinteractive.com/qi-blocks-for-gutenberg/documentation/#call_to_action' );
			$this->set_block_video( 'https://www.youtube.com/watch?v=ibZGWAa_jYM' );

			parent::__construct();
		}

		/**
		 * @return Qi_Blocks_Call_To_Action_Block
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}
	}

	Qi_Blocks_Call_To_Action_Block::get_instance();
}
