<?php

if ( ! function_exists( 'qode_tours_top_reviews_carousel_shortcode_helper' ) ) {
	function qode_tours_top_reviews_carousel_shortcode_helper( $shortcodes_class_name ) {

		$shortcodes = array(
			'QodeTours\CPT\Tours\Shortcodes\TopReviewsCarousel'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'qode_tours_filter_add_vc_shortcode', 'qode_tours_top_reviews_carousel_shortcode_helper' );
}

if( !function_exists('qode_tours_set_top_reviews_carousel_icon_class_name_for_vc_shortcodes') ) {
    /**
     * Function that set custom icon class name for property list shortcode to set our icon for Visual Composer shortcodes panel
     */
    function qode_tours_set_top_reviews_carousel_icon_class_name_for_vc_shortcodes($shortcodes_icon_class_array) {
        $shortcodes_icon_class_array[] = '.icon-wpb-tour-type-list';

        return $shortcodes_icon_class_array;
    }

    add_filter('qode_tours_filter_add_vc_shortcodes_custom_icon_class', 'qode_tours_set_top_reviews_carousel_icon_class_name_for_vc_shortcodes');
}

if(!function_exists('qode_tours_include_elementor_top_reviews_carousel_shortcode')) {
	function qode_tours_include_elementor_top_reviews_carousel_shortcode() {
		include_once QODE_TOURS_CPT_PATH.'/tours/shortcodes/top-reviews-carousel/elementor-top-reviews-carousel.php';
	}
	
	add_action('bridge_core_load_elementor_shortcodes_from_plugins', 'qode_tours_include_elementor_top_reviews_carousel_shortcode');
}

if( ! function_exists( 'qode_tours_include_top_reviews_carousel_shortcode_for_owl_carousel' ) ) {
	function qode_tours_include_top_reviews_carousel_shortcode_for_owl_carousel( $shortcodes_to_check ) {
		$shortcodes_to_check[] = 'qode_top_reviews_carousel';
		
		return $shortcodes_to_check;
	}
	
	add_filter( 'bridge_qode_filter_owl_carousel_shortcodes', 'qode_tours_include_top_reviews_carousel_shortcode_for_owl_carousel' );
}